/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.xmindresource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.ui.internal.xmindresource.Messages;
import org.xmind.ui.internal.xmindresource.XMindResourcePage;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerResourcePage
extends XMindResourcePage {
    private MarkerPageViewer viewer;

    @Override
    protected void createViewer(Composite parent) {
        List markerGroups = MindMapUI.getResourceManager().getUserMarkerSheet().getMarkerGroups();
        if (!markerGroups.isEmpty()) {
            Composite container = this.createViewerContainer(parent);
            container.setLayout((Layout)new FillLayout());
            final ScrolledComposite sc = new ScrolledComposite(container, 768);
            sc.setLayout((Layout)new FillLayout());
            final Composite c = new Composite((Composite)sc, 0);
            c.setLayoutData((Object)new GridData(1808));
            c.setLayout((Layout)new GridLayout());
            this.viewer = new MarkerPageViewer(c);
            this.viewer.setInput(markerGroups);
            ArrayList<Object> allItems = new ArrayList<Object>();
            allItems.addAll(markerGroups);
            this.setAllItems(allItems);
            sc.setContent((Control)c);
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            sc.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = sc.getClientArea();
                    sc.setMinSize(c.computeSize(r.width, -1));
                }
            });
        } else {
            this.createEmptyViewer(parent, Messages.ResourceExportWizardSelectionPage_NoMarker_title, Messages.ResourceExportWizardSelectionPage_NoMarker_Message);
        }
    }

    @Override
    public List<Object> getSelectedResources() {
        return this.viewer != null ? this.viewer.getSelectedItems() : Collections.emptyList();
    }

    @Override
    protected void selectAllItems(boolean selected) {
        this.viewer.selectAllItems(selected);
    }

    @Override
    public Map<Object, Image> getSelectedMap() {
        HashMap<Object, Image> map = new HashMap<Object, Image>();
        for (Object item : this.getSelectedResources()) {
            map.put(item, null);
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MarkerPageViewer {
        private Composite markerPageControl;
        private Map<Button, IMarkerGroup> checkToMarkerGroup = new HashMap<Button, IMarkerGroup>();

        public MarkerPageViewer(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.verticalSpacing = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            this.markerPageControl = composite;
        }

        public void setInput(List<IMarkerGroup> groups) {
            if (groups != null) {
                for (IMarkerGroup markerGroup : groups) {
                    this.createGroup(this.markerPageControl, markerGroup);
                }
            }
        }

        private void createGroup(Composite parent, IMarkerGroup group) {
            final Composite composite = new Composite(parent, 2048);
            composite.setLayout((Layout)new GridLayout(1, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setBackground(Display.getCurrent().getSystemColor(1));
            Button groupControl = new Button(composite, 32);
            this.checkToMarkerGroup.put(groupControl, group);
            groupControl.setText(group.getName());
            groupControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MarkerResourcePage.this.checkAllSelectCheck();
                }
            });
            List markers = group.getMarkers();
            final Composite markersContainer = new Composite(composite, 0);
            GridLayout layout = new GridLayout(23, false);
            markersContainer.setLayout((Layout)layout);
            markersContainer.setBackground(composite.getBackground());
            for (IMarker marker : markers) {
                Label markerLabel = new Label(markersContainer, 0);
                markerLabel.setImage((Image)MarkerResourcePage.this.resources.get((DeviceResourceDescriptor)MarkerImageDescriptor.createFromMarker((IMarker)marker, (int)16, (int)16)));
            }
            composite.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle r = composite.getClientArea();
                    markersContainer.setLayout((Layout)new GridLayout(r.width / 21 - 1, false));
                    composite.layout();
                }
            });
        }

        public List<Object> getSelectedItems() {
            ArrayList<Object> selectedGroups = new ArrayList<Object>();
            Set<Button> keys = this.checkToMarkerGroup.keySet();
            for (Button checkedItem : keys) {
                if (!checkedItem.getSelection()) continue;
                selectedGroups.add(this.checkToMarkerGroup.get(checkedItem));
            }
            return selectedGroups;
        }

        public void selectAllItems(boolean select) {
            if (!this.checkToMarkerGroup.isEmpty()) {
                Set<Button> keys = this.checkToMarkerGroup.keySet();
                for (Button key : keys) {
                    key.setSelection(select);
                }
            }
        }
    }
}

