/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.LoadPhotosWithPointsCmd;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.LatLonRectangle;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.Timestamp;
import tim.prune.data.TimestampLocal;
import tim.prune.data.TimestampUtc;
import tim.prune.data.UnitSetLibrary;
import tim.prune.function.Describer;
import tim.prune.jpeg.InternalExifLibrary;
import tim.prune.jpeg.JpegData;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.JpegFileFilter;
import tim.prune.load.LoadCounts;
import tim.prune.load.MediaLoadProgressDialog;
import tim.prune.load.MediaSorter;

public class JpegLoader {
    private final App _app;
    private final JFrame _parentFrame;
    private JFileChooser _fileChooser = null;
    private final GenericFileFilter _fileFilter;
    private JCheckBox _subdirCheckbox = null;
    private JCheckBox _noExifCheckbox = null;
    private JCheckBox _outsideAreaCheckbox = null;
    private MediaLoadProgressDialog _progressDialog = null;
    private LoadCounts _counters = null;
    private boolean _cancelled = false;
    private LatLonRectangle _trackRectangle = null;
    private ArrayList<Photo> _photos = null;

    public JpegLoader(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
        this._fileFilter = new JpegFileFilter();
    }

    private String getName() {
        return I18nManager.getText("menu.file.addphotos");
    }

    public void openDialog(LatLonRectangle latLonRectangle) {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setMultiSelectionEnabled(true);
            this._fileChooser.setFileSelectionMode(2);
            this._fileChooser.setFileFilter(this._fileFilter);
            this._fileChooser.setDialogTitle(this.getName());
            this._subdirCheckbox = new JCheckBox(I18nManager.getText("dialog.jpegload.subdirectories"));
            this._subdirCheckbox.setSelected(true);
            this._noExifCheckbox = new JCheckBox(I18nManager.getText("dialog.jpegload.loadjpegswithoutcoords"));
            this._noExifCheckbox.setSelected(true);
            this._outsideAreaCheckbox = new JCheckBox(I18nManager.getText("dialog.jpegload.loadjpegsoutsidearea"));
            this._outsideAreaCheckbox.setSelected(true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this._subdirCheckbox);
            jPanel.add(this._noExifCheckbox);
            jPanel.add(this._outsideAreaCheckbox);
            this._fileChooser.setAccessory(jPanel);
            String string = Config.getConfigString("prune.photodirectory");
            if (string == null) {
                string = Config.getConfigString("prune.trackdirectory");
            }
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        this._trackRectangle = latLonRectangle;
        this._outsideAreaCheckbox.setEnabled(this._trackRectangle != null && !this._trackRectangle.isEmpty());
        if (this._fileChooser.showOpenDialog(this._parentFrame) == 0) {
            this._progressDialog = new MediaLoadProgressDialog(this._parentFrame, () -> {
                boolean bl = this._cancelled = true;
            });
            this._progressDialog.show();
            new Thread(this::run).start();
        }
    }

    public void run() {
        this._counters = new LoadCounts();
        this._photos = new ArrayList();
        File[] fileArray = this._fileChooser.getSelectedFiles();
        int n = this.countFileList(fileArray, true, this._subdirCheckbox.isSelected());
        this._progressDialog.showProgress(0, n);
        this._cancelled = false;
        this.processFileList(fileArray, true, this._subdirCheckbox.isSelected());
        SwingUtilities.invokeLater(() -> this._progressDialog.close());
        if (this._cancelled) {
            return;
        }
        if (this._counters.getNumFiles() == 0) {
            this._app.showErrorMessage("error.jpegload.dialogtitle", "error.jpegload.nofilesfound");
        } else if (this._counters.getNumPhotos() == 0) {
            this._app.showErrorMessage("error.jpegload.dialogtitle", "error.jpegload.nojpegsfound");
        } else if (!this._noExifCheckbox.isSelected() && this._counters.getNumPhotos() == 0) {
            this._app.showErrorMessage("error.jpegload.dialogtitle", "error.jpegload.nogpsfound");
        } else {
            Collections.sort(this._photos, new MediaSorter());
            LoadPhotosWithPointsCmd loadPhotosWithPointsCmd = new LoadPhotosWithPointsCmd(this._photos);
            int n2 = this._photos.size();
            Describer describer = new Describer("confirm.jpegload.single", "confirm.jpegload.multi");
            loadPhotosWithPointsCmd.setConfirmText(describer.getDescriptionWithCount(n2));
            Describer describer2 = new Describer("undo.loadphoto", "undo.loadphotos");
            String string = this._photos.get(0).getName();
            loadPhotosWithPointsCmd.setDescription(describer2.getDescriptionWithNameOrCount(string, n2));
            this._app.execute(loadPhotosWithPointsCmd);
        }
    }

    private void processFileList(File[] fileArray, boolean bl, boolean bl2) {
        if (fileArray == null) {
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (!this._cancelled && file.exists() && file.canRead()) {
                if (file.isFile()) {
                    this.processFile(file);
                } else if (file.isDirectory() && (bl || bl2)) {
                    File[] fileArray3 = file.listFiles();
                    this.processFileList(fileArray3, false, bl2);
                }
            }
            ++n2;
        }
    }

    private void processFile(File file) {
        Photo photo;
        this._counters.foundFile();
        this._progressDialog.setValue(this._counters.getNumFiles());
        if (!this._fileFilter.acceptFilename(file.getName())) {
            return;
        }
        if (file.exists() && file.canRead()) {
            this._counters.foundPhoto();
        }
        if ((photo = JpegLoader.createPhoto(file)).getDataPoint() != null) {
            this._counters.foundPhotoWithCoords();
        }
        if ((photo.getDataPoint() != null || this._noExifCheckbox.isSelected()) && (photo.getDataPoint() == null || !this._outsideAreaCheckbox.isEnabled() || this._outsideAreaCheckbox.isSelected() || this._trackRectangle.containsPoint(photo.getDataPoint()))) {
            this._photos.add(photo);
        }
    }

    public static Photo createPhoto(File file) {
        Photo photo = new Photo(file);
        JpegData jpegData = new InternalExifLibrary().getJpegData(file);
        Timestamp timestamp = null;
        if (jpegData != null) {
            if (jpegData.isGpsValid()) {
                timestamp = JpegLoader.createTimestamp(jpegData.getGpsDatestamp(), jpegData.getGpsTimestamp());
                DataPoint dataPoint = JpegLoader.createDataPoint(jpegData);
                dataPoint.setPhoto(photo);
                dataPoint.setSegmentStart(true);
                photo.setDataPoint(dataPoint);
                photo.setOriginalStatus(MediaObject.Status.TAGGED);
            }
            if (timestamp == null && jpegData.getOriginalTimestamp() != null) {
                timestamp = JpegLoader.createTimestamp(jpegData.getOriginalTimestamp());
            }
            if (timestamp == null && jpegData.getDigitizedTimestamp() != null) {
                timestamp = JpegLoader.createTimestamp(jpegData.getDigitizedTimestamp());
            }
            photo.setExifThumbnail(jpegData.getThumbnailImage());
            photo.setRotation(jpegData.getRequiredRotation());
            photo.setBearing(jpegData.getBearing());
        }
        if (timestamp == null) {
            timestamp = new TimestampUtc(file.lastModified());
        }
        photo.setTimestamp(timestamp);
        return photo;
    }

    private int countFileList(File[] fileArray, boolean bl, boolean bl2) {
        int n = 0;
        if (fileArray != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                File file = fileArray[n2];
                if (file.exists() && file.canRead()) {
                    if (n2 == 0 && bl) {
                        File file2 = file.isDirectory() ? file : file.getParentFile();
                        Config.setConfigString("prune.photodirectory", file2.getAbsolutePath());
                    }
                    if (file.isFile()) {
                        ++n;
                    } else if (file.isDirectory() && (bl || bl2)) {
                        n += this.countFileList(file.listFiles(), false, bl2);
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    private static DataPoint createDataPoint(JpegData jpegData) {
        double d = JpegLoader.getCoordinateDoubleValue(jpegData.getLatitude(), jpegData.getLatitudeRef() == 'N' || jpegData.getLatitudeRef() == 'n');
        Latitude latitude = new Latitude(d, 10);
        double d2 = JpegLoader.getCoordinateDoubleValue(jpegData.getLongitude(), jpegData.getLongitudeRef() == 'E' || jpegData.getLongitudeRef() == 'e');
        Longitude longitude = new Longitude(d2, 10);
        Altitude altitude = null;
        if (jpegData.hasAltitude()) {
            altitude = new Altitude(jpegData.getAltitude(), UnitSetLibrary.UNITS_METRES);
        }
        return new DataPoint(latitude, longitude, altitude);
    }

    private static double getCoordinateDoubleValue(double[] dArray, boolean bl) {
        if (dArray == null || dArray.length != 3) {
            return 0.0;
        }
        double d = dArray[0] + dArray[1] / 60.0 + dArray[2] / 60.0 / 60.0;
        d = Math.abs(d);
        return bl ? d : -d;
    }

    private static Timestamp createTimestamp(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null || nArray.length != 3 || nArray2.length != 3) {
            return null;
        }
        return new TimestampLocal(nArray[0], nArray[1], nArray[2], nArray2[0], nArray2[1], nArray2[2]);
    }

    private static Timestamp createTimestamp(String string) {
        TimestampLocal timestampLocal = null;
        try {
            timestampLocal = new TimestampLocal(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(11, 13)), Integer.parseInt(string.substring(14, 16)), Integer.parseInt(string.substring(17)));
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException runtimeException) {}
        return timestampLocal;
    }
}

