/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermTarget;
import org.dita.dost.util.XMLSerializer;
import org.dita.dost.writer.AbstractExtendDitaWriter;
import org.xml.sax.SAXException;

public final class HTMLIndexWriter
extends AbstractExtendDitaWriter {
    @Override
    public void write(File filename) throws DITAOTException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename);
            XMLSerializer serializer = XMLSerializer.newInstance(out);
            Transformer transformer = serializer.getTransformerHandler().getTransformer();
            transformer.setOutputProperty("doctype-public", "-//IETF//DTD HTML//EN");
            transformer.setOutputProperty("method", "html");
            transformer.setOutputProperty("encoding", "UTF-8");
            serializer.writeStartDocument();
            serializer.writeStartElement("html");
            serializer.writeStartElement("head");
            serializer.writeComment("Sitemap 1.0");
            serializer.writeEndElement();
            serializer.writeStartElement("body");
            serializer.writeStartElement("ul");
            String printLetter = "A";
            int termNum = this.termList.size();
            for (int i = 0; i < termNum; ++i) {
                String firstLetter;
                IndexTerm term = (IndexTerm)this.termList.get(i);
                if (i == 0) {
                    printLetter = term.getTermFullName().substring(0, 1);
                    serializer.writeCharacters(printLetter);
                }
                if (!(firstLetter = term.getTermFullName().substring(0, 1)).equals(printLetter)) {
                    printLetter = firstLetter;
                    serializer.writeCharacters(printLetter);
                }
                this.outputIndexTerm(term, serializer);
            }
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndElement();
            serializer.writeEndDocument();
        }
        catch (Exception e) {
            throw new DITAOTException(e);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), e);
                }
            }
        }
    }

    private void outputIndexTerm(IndexTerm term, XMLSerializer serializer) throws SAXException {
        List<IndexTermTarget> targets = term.getTargetList();
        List<IndexTerm> subTerms = term.getSubTerms();
        serializer.writeStartElement("li");
        if (targets.isEmpty()) {
            this.findTargets(term);
            targets = term.getTargetList();
        }
        if (targets.isEmpty()) {
            serializer.writeCharacters(term.getTermFullName());
        } else {
            IndexTermTarget target = targets.get(0);
            serializer.writeStartElement("a");
            serializer.writeAttribute("href", target.getTargetURI());
            serializer.writeCharacters(term.getTermFullName());
            serializer.writeEndElement();
        }
        if (subTerms.size() > 0) {
            serializer.writeStartElement("ul");
            for (IndexTerm subTerm : subTerms) {
                this.outputIndexTerm(subTerm, serializer);
            }
            serializer.writeEndElement();
        }
        serializer.writeEndElement();
    }

    private void findTargets(IndexTerm term) {
        List<IndexTerm> subTerms = term.getSubTerms();
        if (subTerms != null && !subTerms.isEmpty()) {
            for (IndexTerm subTerm : subTerms) {
                List<IndexTermTarget> subTargets = subTerm.getTargetList();
                if (subTargets != null && !subTargets.isEmpty()) {
                    this.findTargets(subTerm);
                }
                term.addTargets(subTerm.getTargetList());
            }
        }
    }

    @Override
    public String getIndexFileName(String outputFileRoot) {
        return outputFileRoot + ".hhk";
    }
}

