/*
 * Decompiled with CFR 0.152.
 */
package org.onemind.commons.java.util;

import java.util.Collection;

public final class StringUtils {
    private StringUtils() {
    }

    public static String concat(Collection l, String delimiter) {
        return StringUtils.concat(l.toArray(), delimiter);
    }

    public static String concat(Object[] objects, String delimiter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            sb.append(objects[i]);
            if (i >= objects.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String substringAfter(String str, String pattern) {
        int i = str.indexOf(pattern);
        if (i == -1) {
            return null;
        }
        return str.substring(i + pattern.length());
    }

    public static String substringAfterLast(String str, String pattern) {
        int i = str.lastIndexOf(pattern);
        if (i == -1) {
            return null;
        }
        return str.substring(i + pattern.length());
    }

    public static String substringBeforeLast(String str, String pattern) {
        int i = str.lastIndexOf(pattern);
        if (i == -1) {
            return null;
        }
        return str.substring(0, i);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNullOrEmpty(Object strObject) {
        if (strObject == null) {
            return true;
        }
        if (strObject instanceof String) {
            return StringUtils.isNullOrEmpty((String)strObject);
        }
        return StringUtils.isNullOrEmpty(strObject.toString());
    }
}

