/*
 * Decompiled with CFR 0.152.
 */
package com.eed3si9n.jarjar;

import com.eed3si9n.jarjar.DepFind;
import com.eed3si9n.jarjar.MainProcessor;
import com.eed3si9n.jarjar.MainUtil;
import com.eed3si9n.jarjar.PatternElement;
import com.eed3si9n.jarjar.RulesFileParser;
import com.eed3si9n.jarjar.StringDumper;
import com.eed3si9n.jarjar.TextDepHandler;
import com.eed3si9n.jarjar.util.RuntimeIOException;
import com.eed3si9n.jarjar.util.StandaloneJarProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;

public class Main {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HELP;
    private boolean verbose;
    private List patterns;
    private int level = 0;

    private static String readIntoString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string).append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        MainUtil.runMain(new Main(), stringArray, "help");
    }

    public void help() {
        System.err.print(HELP);
    }

    public void strings(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("cp is required");
        }
        new StringDumper().run(string, new PrintWriter(System.out));
    }

    public void find(String string, String string2, String string3) throws IOException {
        int n;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("level and cp1 are required");
        }
        if (string3 == null) {
            string3 = string2;
        }
        if ("class".equals(string)) {
            n = 0;
        } else if ("jar".equals(string)) {
            n = 1;
        } else {
            throw new IllegalArgumentException("unknown level " + string);
        }
        PrintWriter printWriter = new PrintWriter(System.out);
        TextDepHandler textDepHandler = new TextDepHandler(printWriter, n);
        new DepFind().run(string2, string3, textDepHandler);
        printWriter.flush();
    }

    public void process(File file, File file2, File file3) throws IOException {
        if (file == null || file2 == null || file3 == null) {
            throw new IllegalArgumentException("rulesFile, inJar, and outJar are required");
        }
        List<PatternElement> list2 = RulesFileParser.parse(file);
        boolean bl = Boolean.getBoolean("verbose");
        boolean bl2 = Boolean.getBoolean("skipManifest");
        MainProcessor mainProcessor = new MainProcessor(list2, bl, bl2, System.getProperty("misplacedClassStrategy"));
        StandaloneJarProcessor.run(file2, file3, mainProcessor);
        mainProcessor.strip(file3);
    }

    static {
        try {
            HELP = Main.readIntoString(Main.class.getResourceAsStream("/help.txt"));
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }
}

