/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.deprecated;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMObjectUtilities;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.UserSelection;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.lst.DeprecatedToken;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class TemplateFeatToken
extends AbstractTokenWithSeparator<PCTemplate>
implements CDOMPrimaryToken<PCTemplate>,
PersistentChoiceActor<CNAbilitySelection>,
DeferredToken<PCTemplate>,
DeprecatedToken {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "FEAT";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCTemplate pct, String value) {
        context.getObjectContext().removeList((CDOMObject)pct, ListKey.FEAT_TOKEN_LIST);
        StringTokenizer tok = new StringTokenizer(value, "|");
        boolean first = true;
        ReferenceManufacturer rm = context.getReferenceContext().getManufacturer(ABILITY_CLASS, (Category)AbilityCategory.FEAT);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (".CLEAR".equals(token)) {
                if (!first) {
                    return new ParseResult.Fail("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + value, context);
                }
            } else {
                CDOMReference ability = TokenUtilities.getTypeOrPrimitive((ReferenceManufacturer)rm, (String)token);
                if (ability == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                context.getObjectContext().addToList((CDOMObject)pct, ListKey.FEAT_TOKEN_LIST, (Object)ability);
            }
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCTemplate pct) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)pct, ListKey.FEAT_TOKEN_LIST);
        Collection added = changes.getAdded();
        Collection removedItems = changes.getRemoved();
        String returnVal = null;
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            returnVal = ".CLEAR";
        } else if (removedItems != null && !removedItems.isEmpty()) {
            context.addWriteMessage(this.getTokenName() + " does not support " + ".CLEAR.");
            return null;
        }
        if (added != null && !added.isEmpty()) {
            returnVal = ReferenceUtilities.joinLstFormat((Collection)added, (String)"|");
        }
        if (returnVal == null) {
            return null;
        }
        return new String[]{returnVal};
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }

    public void applyChoice(CDOMObject owner, CNAbilitySelection choice, PlayerCharacter pc) {
        if (!pc.isImporting()) {
            double cost = ((BigDecimal)choice.getCNAbility().getAbility().getSafe(ObjectKey.SELECTION_COST)).doubleValue();
            if (cost > 1.0E-4) {
                pc.adjustAbilities((Category)AbilityCategory.FEAT, new BigDecimal(cost));
            }
            pc.addAbility(choice, (Object)UserSelection.getInstance(), (Object)UserSelection.getInstance());
        }
        pc.addTemplateFeat(owner, choice);
    }

    public boolean allow(CNAbilitySelection choice, PlayerCharacter pc, boolean allowStack) {
        Ability ability = choice.getCNAbility().getAbility();
        if (!((Visibility)ability.getSafe(ObjectKey.VISIBILITY)).equals((Object)Visibility.DEFAULT)) {
            return false;
        }
        if (!ability.qualifies(pc, (Object)ability)) {
            return false;
        }
        String selection = choice.getSelection();
        return !AbilityUtilities.alreadySelected((PlayerCharacter)pc, (Ability)ability, (String)selection, (boolean)allowStack);
    }

    public CNAbilitySelection decodeChoice(LoadContext context, String s) {
        return CNAbilitySelection.getAbilitySelectionFromPersistentFormat((String)s);
    }

    public String encodeChoice(CNAbilitySelection choice) {
        return choice.getPersistentFormat();
    }

    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, CNAbilitySelection choice) {
    }

    public Class<PCTemplate> getDeferredTokenClass() {
        return PCTemplate.class;
    }

    public void removeChoice(PlayerCharacter pc, CDOMObject owner, CNAbilitySelection choice) {
        Ability anAbility;
        if (!pc.isImporting()) {
            pc.getSpellList();
        }
        if ((anAbility = pc.getMatchingAbility((Category)AbilityCategory.FEAT, choice.getCNAbility().getAbility(), Nature.NORMAL)) != null) {
            pc.removeAbility(choice, (Object)UserSelection.getInstance(), (Object)UserSelection.getInstance());
            CDOMObjectUtilities.removeAdds((CDOMObject)anAbility, (PlayerCharacter)pc);
            CDOMObjectUtilities.restoreRemovals((CDOMObject)anAbility, (PlayerCharacter)pc);
            pc.adjustMoveRates();
        }
    }

    public boolean process(LoadContext context, PCTemplate pct) {
        List list = pct.getListFor(ListKey.FEAT_TOKEN_LIST);
        if (list != null && !list.isEmpty()) {
            AbilityRefChoiceSet rcs = new AbilityRefChoiceSet((CDOMSingleRef)CDOMDirectSingleRef.getRef((Loadable)AbilityCategory.FEAT), (Collection)list, Nature.NORMAL);
            ChoiceSet cs = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)rcs);
            cs.setTitle("Feat Choice");
            ConcretePersistentTransitionChoice tc = new ConcretePersistentTransitionChoice((SelectableSet)cs, FormulaFactory.ONE);
            context.getObjectContext().put((CDOMObject)pct, ObjectKey.TEMPLATE_FEAT, (Object)tc);
            tc.setChoiceActor((ChoiceActor)this);
        }
        return true;
    }

    public String getMessage(CDOMObject obj, String value) {
        return "Feat-based tokens have been deprecated - use ABILITY based functions";
    }
}

