/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import gmgen.plugin.Event;
import gmgen.plugin.InitHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import pcgen.core.SettingsHandler;
import plugin.initiative.gui.Initiative;
import plugin.initiative.gui.Utils;

public class StartEvent
extends JDialog {
    protected JPanel mainPanel;
    public Initiative initiative;
    protected JButton bCancel;
    protected JButton bSave;
    protected JCheckBox cbAlert;
    protected JLabel nameLabel;
    protected JLabel playerLabel;
    protected JLabel durationLabel;
    protected JLabel effectLabel;
    protected JLabel initiativeLabel;
    protected JSlider sDuration;
    protected JSlider sInit;
    protected JFormattedTextField lDuration;
    protected JFormattedTextField lInit;
    protected JTextField tEffect;
    protected JTextField tName;
    protected JTextField tPlayer;
    protected String sTitle = "Start Event Timer";
    protected String sAlertLabel = "Alert when event Completes/Occurs";
    protected int gridBagRow = 0;

    public StartEvent(Frame parent, boolean modal, Initiative initiative) {
        super(parent, modal);
        this.initComponents();
        this.initiative = initiative;
        this.initCheckBox();
    }

    public StartEvent(Frame parent, boolean modal, Initiative initiative, String player, int init) {
        super(parent, modal);
        this.initComponents();
        this.initiative = initiative;
        this.tName.grabFocus();
        this.tPlayer.setText(player);
        this.lInit.setValue(init);
        this.initCheckBox();
    }

    public void initCheckBox() {
        boolean box = SettingsHandler.getGMGenOption((String)"Initiative.ShowEvents", (boolean)true);
        if (box) {
            this.cbAlert.setSelected(false);
        } else {
            this.cbAlert.setSelected(true);
        }
    }

    protected void cancelAndClose(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    protected void saveAndClose(ActionEvent e) {
        this.save();
    }

    protected void save() {
        this.initiative.initList.add((InitHolder)new Event(this.tName.getText(), this.tPlayer.getText(), this.tEffect.getText(), ((Integer)this.lDuration.getValue()).intValue(), ((Integer)this.lInit.getValue()).intValue(), this.cbAlert.isSelected()));
        this.initiative.writeToCombatTabWithRound(" Event Timer " + this.tName.getText() + " Started");
        this.initiative.refreshTable();
        this.initiative.grabFocus();
        this.initiative.focusNextInit();
        this.setVisible(false);
        this.dispose();
    }

    protected void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    protected void initComponents() {
        this.basicSetup();
        this.initAllDefaultComponents();
        this.addButtons();
        this.finalizeSetup();
    }

    protected void initAllDefaultComponents() {
        this.addName();
        this.addPlayer();
        this.addEffect();
        this.addDuration();
        this.addInitiative();
        this.addAlert();
    }

    protected void finalizeSetup() {
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    protected void addButtons() {
        this.bSave = new JButton();
        this.bCancel = new JButton();
        this.bSave.setText("Save");
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartEvent.this.saveAndClose(e);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow;
        this.mainPanel.add((Component)this.bSave, gridBagConstraints);
        this.bCancel.setText("Cancel");
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartEvent.this.cancelAndClose(e);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        this.mainPanel.add((Component)this.bCancel, gridBagConstraints);
    }

    protected void addEffect() {
        this.effectLabel = new JLabel();
        this.tEffect = new JTextField();
        this.effectLabel.setText("Effect");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.effectLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.tEffect, gridBagConstraints);
        this.tEffect.addKeyListener(new EnterKeyAdapter());
    }

    protected void addAlert() {
        this.cbAlert = new JCheckBox();
        this.cbAlert.setText(this.sAlertLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.cbAlert, gridBagConstraints);
        this.cbAlert.addKeyListener(new EnterKeyAdapter());
    }

    protected void addInitiative() {
        this.initiativeLabel = new JLabel();
        this.sInit = Utils.buildSlider(1, 50);
        this.lInit = Utils.buildIntegerFieldWithSlider(this.sInit);
        this.lInit.setValue(1);
        this.initiativeLabel.setText("Initiative");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.initiativeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = this.gridBagRow;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.mainPanel.add((Component)this.sInit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.lInit, gridBagConstraints);
        this.lInit.setMinimumSize(new Dimension(this.lInit.getPreferredSize().width, this.lInit.getPreferredSize().height));
        this.lInit.addKeyListener(new EnterKeyAdapter());
    }

    protected void addDuration() {
        this.durationLabel = new JLabel();
        this.sDuration = Utils.buildSlider(1, 50);
        this.lDuration = Utils.buildIntegerFieldWithSlider(this.sDuration);
        this.lDuration.setValue(1);
        this.durationLabel.setText("Duration");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.durationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = this.gridBagRow;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = -80;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 11;
        this.mainPanel.add((Component)this.sDuration, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.mainPanel.add((Component)this.lDuration, gridBagConstraints);
        this.lDuration.setMinimumSize(new Dimension(this.lDuration.getPreferredSize().width, this.lDuration.getPreferredSize().height));
        this.lDuration.addKeyListener(new EnterKeyAdapter());
    }

    protected void addPlayer() {
        this.playerLabel = new JLabel();
        this.tPlayer = new JTextField();
        this.playerLabel.setText("Player");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.playerLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 37;
        gridBagConstraints.anchor = 11;
        this.mainPanel.add((Component)this.tPlayer, gridBagConstraints);
        this.tPlayer.addKeyListener(new EnterKeyAdapter());
    }

    protected void basicSetup() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setTitle(this.sTitle);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StartEvent.this.closeDialog(evt);
            }
        });
    }

    protected void addName() {
        this.nameLabel = new JLabel();
        this.tName = new JTextField();
        this.nameLabel.setText("Name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.gridBagRow;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.gridBagRow++;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 37;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 11;
        this.mainPanel.add((Component)this.tName, gridBagConstraints);
        this.tName.addKeyListener(new EnterKeyAdapter());
    }

    protected class EnterKeyAdapter
    extends KeyAdapter {
        protected EnterKeyAdapter() {
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                StartEvent.this.save();
            }
        }
    }
}

