/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.spell;

import pcgen.base.util.HashMapToList;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractRestrictedSpellPrimitive;

public class SpellTypeToken
extends AbstractRestrictedSpellPrimitive {
    private String spelltype;

    public boolean initialize(LoadContext context, Class<Spell> cl, String value, String args) {
        if (value == null) {
            return false;
        }
        this.spelltype = value;
        return this.initialize(context, args);
    }

    public String getTokenName() {
        return "SPELLTYPE";
    }

    public boolean allow(PlayerCharacter pc, Spell spell) {
        HashMapToList levelInfo = pc.getSpellLevelInfo(spell);
        String source = "SPELLTYPE:" + this.spelltype;
        for (CDOMList spellList : levelInfo.getKeySet()) {
            if (!spellList.isType(this.spelltype)) continue;
            for (Integer level : levelInfo.getListFor((Object)spellList)) {
                if (!this.allow(pc, level, source, spell, null)) continue;
                return true;
            }
        }
        return false;
    }

    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpellTypeToken) {
            SpellTypeToken other = (SpellTypeToken)((Object)obj);
            if (this.spelltype == null) {
                return other.spelltype == null;
            }
            return this.spelltype.equals(other.spelltype) && this.equalsRestrictedPrimitive(other);
        }
        return false;
    }

    public int hashCode() {
        return this.spelltype == null ? -23 : this.spelltype.hashCode();
    }

    public CharSequence getPrimitiveLST() {
        return new StringBuilder().append(this.getTokenName()).append('=').append(this.spelltype).append(this.getRestrictionLST());
    }
}

