/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Equipment;
import pcgen.core.SpecialProperty;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SpropToken
extends AbstractTokenWithSeparator<Equipment>
implements CDOMPrimaryToken<Equipment> {
    @Override
    public String getTokenName() {
        return "SPROP";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Equipment eq, String value) {
        if (".CLEAR".equals(value)) {
            context.getObjectContext().removeList(eq, ListKey.SPECIAL_PROPERTIES);
            return ParseResult.SUCCESS;
        }
        SpecialProperty sa = SpecialProperty.createFromLst(value);
        if (sa == null) {
            return ParseResult.INTERNAL_ERROR;
        }
        context.getObjectContext().addToList(eq, ListKey.SPECIAL_PROPERTIES, sa);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Equipment eq) {
        Changes<SpecialProperty> changes = context.getObjectContext().getListChanges(eq, ListKey.SPECIAL_PROPERTIES);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Collection<SpecialProperty> added = changes.getAdded();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            list.add(".CLEAR");
        }
        if (added != null && !added.isEmpty()) {
            for (SpecialProperty sp : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(sp.getDisplayName());
                if (sp.hasPrerequisites()) {
                    sb.append("|");
                    sb.append(this.getPrerequisiteString(context, sp.getPrerequisiteList()));
                }
                list.add(sb.toString());
            }
        }
        if (list.isEmpty()) {
            context.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

