/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.core.Equipment;
import pcgen.core.EquipmentUtilities;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.io.ExportHandler;
import pcgen.io.FileAccess;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;

public class EqToken
extends Token {
    public static final String TOKENNAME = "EQ";
    private static String cachedString = null;
    private static List<Equipment> cachedList = null;
    private static int cachedSerial = 0;
    private static PlayerCharacter cachedPC = null;

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String token;
        String bFilter = "";
        String befTrue = "";
        String aftTrue = "";
        String befFalse = "";
        String aftFalse = "";
        StringTokenizer bTok = new StringTokenizer(tokenSource, "~");
        if (bTok.countTokens() >= 3) {
            bFilter = bTok.nextToken();
            befTrue = bTok.nextToken();
            aftTrue = bTok.nextToken();
            if (bTok.hasMoreTokens()) {
                befFalse = bTok.nextToken();
                aftFalse = bTok.nextToken();
            }
            tokenSource = tokenSource.substring(0, bFilter.lastIndexOf(46));
        }
        bTok = new StringTokenizer(bFilter, ".");
        boolean if_detected = false;
        while (bTok.hasMoreTokens()) {
            String bString = bTok.nextToken();
            if ("IF".equals(bString)) {
                if_detected = true;
                continue;
            }
            if (if_detected) {
                bFilter = bFilter + "." + bString;
                continue;
            }
            bFilter = bString;
        }
        String comparatorString = tokenSource.split("[0-9]+")[0];
        List<Equipment> eqList = null;
        StringTokenizer aTok = null;
        int temp = -1;
        if (comparatorString.equals(cachedString) && pc == cachedPC && pc.getSerial() == cachedSerial) {
            eqList = cachedList;
            tokenSource = tokenSource.substring(comparatorString.length());
            aTok = new StringTokenizer(tokenSource, ".", false);
            token = aTok.nextToken();
            while (aTok.hasMoreTokens()) {
                try {
                    temp = Integer.parseInt(token);
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (temp < 0) {
                    token = aTok.nextToken();
                    continue;
                }
                break;
            }
        } else {
            aTok = new StringTokenizer(tokenSource, ".", false);
            aTok.nextToken();
            token = aTok.nextToken();
            int merge = 0;
            if (token.indexOf("MERGE") >= 0) {
                merge = EqToken.returnMergeType(token);
                token = aTok.nextToken();
            }
            eqList = new ArrayList<Equipment>();
            for (Equipment eq : pc.getEquipmentListInOutputOrder(merge)) {
                eqList.add(eq);
            }
            while (aTok.hasMoreTokens()) {
                if ("NOT".equalsIgnoreCase(token)) {
                    eqList = EqToken.listNotType(eqList, aTok.nextToken());
                } else if ("ADD".equalsIgnoreCase(token)) {
                    eqList = EqToken.listAddType(pc, eqList, aTok.nextToken());
                } else if ("IS".equalsIgnoreCase(token)) {
                    eqList = EqToken.listIsType(eqList, aTok.nextToken());
                } else {
                    try {
                        temp = Integer.parseInt(token);
                    }
                    catch (NumberFormatException exc) {
                        // empty catch block
                    }
                }
                if (temp >= 0) break;
                token = aTok.nextToken();
            }
            cachedList = eqList;
            cachedString = comparatorString;
            cachedPC = pc;
            cachedSerial = pc.getSerial();
        }
        String retString = "";
        if (aTok.hasMoreTokens()) {
            String tempString = aTok.nextToken();
            if (temp >= 0 && temp < eqList.size()) {
                Equipment eq = eqList.get(temp);
                retString = FileAccess.filterString(EqToken.getEqToken(pc, eq, tempString, aTok));
                if (!"".equals(bFilter)) {
                    aTok = new StringTokenizer(bFilter, ".");
                    boolean result = false;
                    boolean and_operation = false;
                    while (aTok.hasMoreTokens()) {
                        String bString = aTok.nextToken();
                        if ("AND".equals(bString)) {
                            and_operation = true;
                            continue;
                        }
                        if ("OR".equals(bString)) {
                            and_operation = false;
                            continue;
                        }
                        if (and_operation) {
                            result = result && eq.isType(bString);
                            continue;
                        }
                        result = result || eq.isType(bString);
                    }
                    retString = result ? befTrue + retString + aftTrue : befFalse + retString + aftFalse;
                }
            }
        }
        return retString;
    }

    @Override
    public boolean isEncoded() {
        return false;
    }

    public static String getAcCheckToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getAcCheckTokenInt(pc, eq) + "";
    }

    public static int getAcCheckTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.acCheck(pc);
    }

    public static String getAcModToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getAcModTokenInt(pc, eq) + "";
    }

    public static int getAcModTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.getACMod(pc);
    }

    public static String getAltCritMultToken(Equipment eq) {
        return eq.getAltCritMult();
    }

    public static String getAltCritRangeToken(PlayerCharacter pc, Equipment eq) {
        int critRange = pc.getCritRange(eq, false);
        return critRange == 0 ? "" : Integer.toString(critRange);
    }

    public static String getAltDamageToken(PlayerCharacter pc, Equipment eq) {
        return eq.getAltDamage(pc);
    }

    public static String getAttacksToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getAttacksTokenDouble(pc, eq) + "";
    }

    public static double getAttacksTokenDouble(PlayerCharacter pc, Equipment eq) {
        return eq.bonusTo(pc, "COMBAT", "ATTACKS", true);
    }

    public static String getCarriedToken(Equipment eq) {
        return EqToken.getCarriedTokenFloat(eq) + "";
    }

    public static float getCarriedTokenFloat(Equipment eq) {
        return eq.numberCarried().floatValue();
    }

    public static String getChargesToken(Equipment eq) {
        String retString = "";
        int charges = EqToken.getChargesTokenInt(eq);
        if (charges >= 0) {
            retString = charges + "";
        }
        return retString;
    }

    public static int getChargesTokenInt(Equipment eq) {
        return eq.getRemainingCharges();
    }

    public static String getChargesUsedToken(Equipment eq) {
        String retString = "";
        int charges = EqToken.getChargesUsedTokenInt(eq);
        if (charges >= 0) {
            retString = charges + "";
        }
        return retString;
    }

    public static int getChargesUsedTokenInt(Equipment eq) {
        return eq.getUsedCharges();
    }

    public static double getContentWeightTokenDouble(PlayerCharacter pc, Equipment eq) {
        if (eq.getChildCount() == 0) {
            return 0.0;
        }
        return eq.getContainedWeight(pc, true).doubleValue();
    }

    public static String getContentsToken(PlayerCharacter pc, Equipment eq, StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            String bType = tokenizer.nextToken();
            String aSubTag = "NAME";
            if (tokenizer.hasMoreTokens()) {
                aSubTag = tokenizer.nextToken();
            }
            try {
                int contentsIndex = Integer.parseInt(bType);
                return EqToken.getEqToken(pc, eq.getContainedByIndex(contentsIndex), aSubTag, tokenizer);
            }
            catch (NumberFormatException e) {
                return eq.getContainerByType(bType, aSubTag);
            }
        }
        return EqToken.getContentsToken(eq);
    }

    public static String getContentsToken(Equipment eq) {
        return eq.getContainerContentsString();
    }

    public static String getContentsNumToken(Equipment eq) {
        return EqToken.getContentsNumTokenInt(eq) + "";
    }

    public static int getContentsNumTokenInt(Equipment eq) {
        return eq.getContents().size();
    }

    public static String getCostToken(PlayerCharacter pc, Equipment eq) {
        return BigDecimalHelper.trimZeros(eq.getCost(pc));
    }

    public static String getCritMultToken(Equipment eq) {
        return eq.getCritMult();
    }

    public static String getCritRangeToken(PlayerCharacter pc, Equipment eq) {
        int critRange = pc.getCritRange(eq, true);
        return critRange == 0 ? "" : Integer.toString(critRange);
    }

    public static String getDamageToken(PlayerCharacter pc, Equipment eq) {
        return eq.getDamage(pc);
    }

    public static String getDescriptionToken(PlayerCharacter aPC, Equipment eq) {
        return aPC.getDescription(eq);
    }

    public static String getEdrToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getEdrTokenInt(pc, eq) + "";
    }

    public static int getEdrTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.eDR(pc);
    }

    public static String getEquippedToken(Equipment eq) {
        return EqToken.getEquippedTokenBoolean(eq) ? "Y" : "N";
    }

    public static boolean getEquippedTokenBoolean(Equipment eq) {
        return eq.isEquipped();
    }

    public static String getFumbleRangeToken(Equipment eq) {
        return eq.getFumbleRange();
    }

    public static String getIsTypeToken(Equipment eq, String type) {
        return EqToken.getIsTypeTokenBoolean(eq, type) ? "TRUE" : "FALSE";
    }

    public static boolean getIsTypeTokenBoolean(Equipment eq, String type) {
        return eq.isType(type);
    }

    public static String getLocationToken(Equipment eq) {
        Equipment obj = eq.getParent();
        if (obj != null) {
            return OutputNameFormatting.getOutputName(obj);
        }
        return eq.getParentName();
    }

    public static String getLongNameToken(Equipment eq) {
        return eq.longName();
    }

    public static String getMaxChargesToken(Equipment eq) {
        String retString = "";
        int charges = EqToken.getMaxChargesTokenInt(eq);
        if (charges >= 0) {
            retString = charges + "";
        }
        return retString;
    }

    public static int getMaxChargesTokenInt(Equipment eq) {
        return eq.getMaxCharges();
    }

    public static String getMaxDexToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getMaxDexTokenInt(pc, eq) + "";
    }

    public static int getMaxDexTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.getMaxDex(pc);
    }

    public static String getMoveToken(Equipment eq) {
        return eq.moveString();
    }

    public static String getNameToken(Equipment eq, PlayerCharacter pc) {
        return OutputNameFormatting.parseOutputName(eq, pc);
    }

    public static String getNoteToken(Equipment eq) {
        return eq.getNote();
    }

    public static String getQtyToken(Equipment eq) {
        return BigDecimalHelper.trimZeros(Double.toString(EqToken.getQtyDoubleToken(eq)));
    }

    public static double getQtyDoubleToken(Equipment eq) {
        return eq.qty();
    }

    public static double getCheckboxesDoubleToken(Equipment eq) {
        if (SettingsHandler.getShowSingleBoxPerBundle()) {
            return EqToken.getQtyDoubleToken(eq);
        }
        return EqToken.getQtyDoubleToken(eq) * (double)eq.getSafe(IntegerKey.BASE_QUANTITY);
    }

    public static String getCheckboxesToken(Equipment eq) {
        return BigDecimalHelper.trimZeros(Double.toString(EqToken.getCheckboxesDoubleToken(eq)));
    }

    public static String getRangeToken(Equipment eq, PlayerCharacter pc) {
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(eq.getRange(pc).intValue()) + Globals.getGameModeUnitSet().getDistanceUnit();
    }

    public static String getSizeToken(Equipment eq) {
        return eq.getSize();
    }

    public static String getSizeLongToken(Equipment eq) {
        return eq.getSafe(ObjectKey.SIZE).resolvesTo().getDisplayName();
    }

    public static String getSlotToken(Equipment eq) {
        return eq.getSlot();
    }

    public static String getSourceToken(Equipment eq) {
        return SourceFormat.getFormattedString(eq, Globals.getSourceDisplay(), true);
    }

    public static String getSpellFailureToken(PlayerCharacter pc, Equipment eq) {
        return EqToken.getSpellFailureTokenInt(pc, eq) + "";
    }

    public static int getSpellFailureTokenInt(PlayerCharacter pc, Equipment eq) {
        return eq.spellFailure(pc);
    }

    public static String getSpropToken(PlayerCharacter pc, Equipment eq) {
        return eq.getSpecialProperties(pc);
    }

    public static double getTotalWeightTokenDouble(PlayerCharacter pc, Equipment eq) {
        return EqToken.getContentWeightTokenDouble(pc, eq) + EqToken.getWtTokenDouble(pc, eq);
    }

    public static double getTotalWtTokenDouble(PlayerCharacter pc, Equipment eq) {
        return eq.qty() * eq.getWeightAsDouble(pc);
    }

    public static String getTypeToken(Equipment eq) {
        return eq.getType().toUpperCase();
    }

    public static String getTypeToken(Equipment eq, int num) {
        return eq.typeIndex(num).toUpperCase();
    }

    public static double getWtTokenDouble(PlayerCharacter pc, Equipment eq) {
        return eq.getWeightAsDouble(pc);
    }

    public static List<Equipment> listNotType(List<Equipment> eqList, String type) {
        return EquipmentUtilities.removeEqType(eqList, type);
    }

    public static List<Equipment> listAddType(PlayerCharacter pc, List<Equipment> eqList, String type) {
        return pc.addEqType(eqList, type);
    }

    public static List<Equipment> listIsType(List<Equipment> eqList, String type) {
        return EquipmentUtilities.removeNotEqType(eqList, type);
    }

    protected static String getEqToken(PlayerCharacter pc, Equipment eq, String token, StringTokenizer tokenizer) {
        String retString = "";
        if ("LONGNAME".equals(token)) {
            retString = EqToken.getLongNameToken(eq);
        } else if ("NAME".equals(token) || "OUTPUTNAME".equals(token)) {
            retString = EqToken.getNameToken(eq, pc);
        } else if ("NOTE".equals(token)) {
            retString = EqToken.getNoteToken(eq);
        } else if ("WT".equals(token) || "ITEMWEIGHT".equals(token)) {
            retString = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getWtTokenDouble(pc, eq));
        } else if ("TOTALWT".equals(token)) {
            retString = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getTotalWtTokenDouble(pc, eq));
        } else if ("TOTALWEIGHT".equals(token)) {
            retString = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getTotalWeightTokenDouble(pc, eq));
        } else if ("ISTYPE".equals(token)) {
            retString = EqToken.getIsTypeToken(eq, tokenizer.nextToken());
        } else if ("CHECKBOXES".equals(token)) {
            retString = EqToken.getCheckboxesToken(eq);
        } else if ("CONTENTWEIGHT".equals(token)) {
            retString = Globals.getGameModeUnitSet().displayWeightInUnitSet(EqToken.getContentWeightTokenDouble(pc, eq));
        } else if ("COST".equals(token)) {
            retString = EqToken.getCostToken(pc, eq);
        } else if ("DESC".equals(token)) {
            retString = EqToken.getDescriptionToken(pc, eq);
        } else if ("FUMBLERANGE".equals(token)) {
            retString = EqToken.getFumbleRangeToken(eq);
        } else if ("QTY".equals(token)) {
            retString = EqToken.getQtyToken(eq);
        } else if ("EQUIPPED".equals(token)) {
            retString = EqToken.getEquippedToken(eq);
        } else if ("CARRIED".equals(token)) {
            retString = EqToken.getCarriedToken(eq);
        } else if ("CONTENTSNUM".equals(token)) {
            retString = EqToken.getContentsNumToken(eq);
        } else if ("LOCATION".equals(token)) {
            retString = EqToken.getLocationToken(eq);
        } else if ("ACMOD".equals(token)) {
            retString = EqToken.getAcModToken(pc, eq);
        } else if ("MAXDEX".equals(token)) {
            retString = EqToken.getMaxDexToken(pc, eq);
        } else if ("ACCHECK".equals(token)) {
            retString = EqToken.getAcCheckToken(pc, eq);
        } else if ("EDR".equals(token)) {
            retString = EqToken.getEdrToken(pc, eq);
        } else if ("MOVE".equals(token)) {
            retString = EqToken.getMoveToken(eq);
        } else {
            if ("TYPE".equals(token)) {
                if (tokenizer.hasMoreTokens()) {
                    try {
                        int num = Integer.parseInt(tokenizer.nextToken());
                        return EqToken.getTypeToken(eq, num);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                return EqToken.getTypeToken(eq);
            }
            if ("QUALITY".equals(token)) {
                Map<String, String> qualityMap = eq.getMapFor(MapKey.QUALITY);
                if (qualityMap != null) {
                    if (tokenizer.hasMoreTokens()) {
                        block92: {
                            String next = tokenizer.nextToken();
                            try {
                                int idx = Integer.parseInt(next);
                                for (String value : qualityMap.values()) {
                                    if (--idx != 0) continue;
                                    return value;
                                }
                            }
                            catch (NumberFormatException e) {
                                String value = qualityMap.get(next);
                                if (value == null) break block92;
                                return value;
                            }
                        }
                        return "";
                    }
                    TreeSet<String> qualities = new TreeSet<String>();
                    for (Map.Entry<String, String> me : qualityMap.entrySet()) {
                        qualities.add(me.getKey() + ": " + me.getValue());
                    }
                    return StringUtil.join(qualities, (String)", ");
                }
                return "";
            }
            if ("SPELLFAILURE".equals(token)) {
                retString = EqToken.getSpellFailureToken(pc, eq);
            } else if ("SIZE".equals(token)) {
                retString = EqToken.getSizeToken(eq);
            } else if ("SIZELONG".equals(token)) {
                retString = EqToken.getSizeLongToken(eq);
            } else if ("DAMAGE".equals(token)) {
                retString = EqToken.getDamageToken(pc, eq);
            } else if ("CRITRANGE".equals(token)) {
                retString = EqToken.getCritRangeToken(pc, eq);
            } else if ("CRITMULT".equals(token)) {
                retString = EqToken.getCritMultToken(eq);
            } else if ("ALTDAMAGE".equals(token)) {
                retString = EqToken.getAltDamageToken(pc, eq);
            } else if ("ALTCRITMULT".equals(token) || "ALTCRIT".equals(token)) {
                retString = EqToken.getAltCritMultToken(eq);
            } else if ("ALTCRITRANGE".equals(token)) {
                retString = EqToken.getAltCritRangeToken(pc, eq);
            } else if ("RANGE".equals(token)) {
                retString = EqToken.getRangeToken(eq, pc);
            } else if ("ATTACKS".equals(token)) {
                retString = EqToken.getAttacksToken(pc, eq);
            } else if ("PROF".equals(token)) {
                retString = eq.consolidatedProfName();
            } else if ("SPROP".equals(token)) {
                retString = EqToken.getSpropToken(pc, eq);
            } else if ("CHARGES".equals(token)) {
                retString = EqToken.getChargesToken(eq);
            } else if ("CHARGESUSED".equals(token)) {
                retString = EqToken.getChargesUsedToken(eq);
            } else if ("MAXCHARGES".equals(token)) {
                retString = EqToken.getMaxChargesToken(eq);
            } else if ("CONTENTS".equals(token)) {
                retString = EqToken.getContentsToken(pc, eq, tokenizer);
            } else if ("SOURCE".equals(token)) {
                retString = EqToken.getSourceToken(eq);
            } else if ("SLOT".equals(token)) {
                retString = EqToken.getSlotToken(eq);
            }
        }
        return retString;
    }

    protected static int returnMergeType(String type) {
        int merge = 0;
        if ("MERGENONE".equals(type)) {
            merge = 1;
        } else if ("MERGELOC".equals(type)) {
            merge = 2;
        } else if ("MERGEALL".equals(type)) {
            merge = 0;
        }
        return merge;
    }
}

