/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChoiceManager;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.gui2.facade.Gui2InfoFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.chooser.ChooserFactory;

public class UserInputManager
extends CDOMChoiceManager<String> {
    public UserInputManager(ChooseDriver cdo, ChooseInformation<String> chooseType, int cost) {
        super(cdo, chooseType, null, cost);
    }

    @Override
    public List<String> doChooser(PlayerCharacter aPc, List<String> availableList, List<String> selectedList, List<String> reservedList) {
        String title;
        int effectiveChoices = this.getNumEffectiveChoices(selectedList, reservedList, aPc);
        boolean dupsAllowed = this.controller.isMultYes() && this.controller.isStackYes();
        Globals.sortChooserLists(availableList, selectedList);
        String string = title = StringUtils.isBlank(this.info.getTitle()) ? "in_chooser" : this.info.getTitle();
        if (title.startsWith("in_")) {
            title = LanguageBundle.getString(title);
        }
        CDOMChooserFacadeImpl<String> chooserFacade = new CDOMChooserFacadeImpl<String>(title, availableList, selectedList, effectiveChoices);
        chooserFacade.setAllowsDups(dupsAllowed);
        chooserFacade.setInfoFactory(new Gui2InfoFactory(aPc));
        chooserFacade.setUserInput(true);
        ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
        return chooserFacade.getFinalSelected();
    }
}

