/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.Comparator;
import pcgen.cdom.base.PrimitiveChoiceSet;

public final class ChoiceSetUtilities {
    public static final Comparator<PrimitiveChoiceSet<?>> WRITEABLE_SORTER = new Comparator<PrimitiveChoiceSet<?>>(){

        @Override
        public int compare(PrimitiveChoiceSet<?> arg0, PrimitiveChoiceSet<?> arg1) {
            return ChoiceSetUtilities.compareChoiceSets(arg0, arg1);
        }
    };

    private ChoiceSetUtilities() {
    }

    public static int compareChoiceSets(PrimitiveChoiceSet<?> pcs1, PrimitiveChoiceSet<?> pcs2) {
        String base = pcs1.getLSTformat(false);
        if (base == null) {
            if (pcs2.getLSTformat(false) == null) {
                return 0;
            }
            return -1;
        }
        if (pcs2.getLSTformat(false) == null) {
            return 1;
        }
        return base.compareTo(pcs2.getLSTformat(false));
    }

    public static String joinLstFormat(Collection<? extends PrimitiveChoiceSet<?>> pcsCollection, String separator, boolean useAny) {
        if (pcsCollection == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(pcsCollection.size() * 10);
        boolean needjoin = false;
        for (PrimitiveChoiceSet<?> pcs : pcsCollection) {
            if (needjoin) {
                result.append(separator);
            }
            needjoin = true;
            result.append(pcs.getLSTformat(useAny));
        }
        return result.toString();
    }
}

