/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Dice;
import gmgen.plugin.SystemAttribute;

public class SystemInitiative {
    protected Dice die;
    protected SystemAttribute attribute;
    protected int bonus;
    protected int currentInitiative = 0;
    protected int mod = 0;
    protected int roll;

    public SystemInitiative(SystemAttribute attribute, int bonus) {
        this.attribute = attribute;
        this.bonus = bonus;
        this.die = new Dice(1, 20);
    }

    public SystemInitiative(SystemAttribute attribute) {
        this(attribute, 0);
    }

    public SystemInitiative(int bonus) {
        this(new SystemAttribute("Attribute", 10), bonus);
    }

    public SystemInitiative() {
        this(new SystemAttribute("Attribute", 10), 0);
    }

    public void setAttribute(SystemAttribute attribute) {
        this.attribute = attribute;
    }

    public SystemAttribute getAttribute() {
        return this.attribute;
    }

    public void setBonus(int bonus) {
        this.bonus = bonus - this.attribute.getModifier();
        if (this.getCurrentInitiative() > 0) {
            this.setCurrentInitiative(this.roll + this.getModifier() + this.mod);
        }
    }

    public int getBonus() {
        return this.bonus;
    }

    public void resetCurrentInitiative() {
        this.currentInitiative = 0;
    }

    public void setCurrentInitiative(int currentInitiative) {
        this.currentInitiative = currentInitiative >= 1 ? currentInitiative : 1;
    }

    public int getCurrentInitiative() {
        return this.currentInitiative;
    }

    public int getModifier() {
        return this.attribute.getModifier() + this.bonus;
    }

    public int check() {
        return this.check(0);
    }

    public int check(int modifier) {
        this.roll = this.die.roll();
        this.mod = modifier;
        this.setCurrentInitiative(this.roll + this.getModifier() + modifier);
        return this.currentInitiative;
    }

    public int checkExtRoll(int aRoll) {
        return this.checkExtRoll(aRoll, 0);
    }

    public int checkExtRoll(int aRoll, int modifier) {
        this.roll = aRoll;
        this.mod = modifier;
        this.setCurrentInitiative(aRoll + this.getModifier() + modifier);
        return this.currentInitiative;
    }

    public int refocus() {
        return this.checkExtRoll(20, 0);
    }

    public int refocus(int modifier) {
        return this.checkExtRoll(20, modifier);
    }
}

