/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.plaf.basic;

import com.jgoodies.components.JGHyperlink;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicHyperlinkUI
extends BasicButtonUI {
    private static BasicHyperlinkUI hyperlinkUI;
    protected static final Rectangle VIEW_RECT;
    protected static final Rectangle TEXT_RECT;
    protected static final Rectangle ICON_RECT;

    public static ComponentUI createUI(JComponent x) {
        if (hyperlinkUI == null) {
            hyperlinkUI = new BasicHyperlinkUI();
        }
        return hyperlinkUI;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        this.defaultTextShiftOffset = 0;
        b.setHorizontalAlignment(10);
        b.setBorder(null);
        JGHyperlink link = (JGHyperlink)b;
        if (link.getForeground() == null || link.getForeground() instanceof ColorUIResource) {
            link.setForeground(UIManager.getColor("Hyperlink.unvisited.foreground"));
        }
        if (link.getVisitedForeground() == null || link.getVisitedForeground() instanceof ColorUIResource) {
            link.setVisitedForeground(UIManager.getColor("Hyperlink.visited.foreground"));
        }
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new Handler((JGHyperlink)b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JGHyperlink b = (JGHyperlink)c;
        ButtonModel model = b.getModel();
        Font f = b.getFont();
        g.setFont(f);
        FontMetrics fm = b.getFontMetrics(f);
        Insets i = b.getInsets();
        BasicHyperlinkUI.VIEW_RECT.x = i.left;
        BasicHyperlinkUI.VIEW_RECT.y = i.top;
        BasicHyperlinkUI.VIEW_RECT.width = b.getWidth() - (i.right + BasicHyperlinkUI.VIEW_RECT.x);
        BasicHyperlinkUI.VIEW_RECT.height = b.getHeight() - (i.bottom + BasicHyperlinkUI.VIEW_RECT.y);
        BasicHyperlinkUI.TEXT_RECT.height = 0;
        BasicHyperlinkUI.TEXT_RECT.width = 0;
        BasicHyperlinkUI.TEXT_RECT.y = 0;
        BasicHyperlinkUI.TEXT_RECT.x = 0;
        BasicHyperlinkUI.ICON_RECT.height = 0;
        BasicHyperlinkUI.ICON_RECT.width = 0;
        BasicHyperlinkUI.ICON_RECT.y = 0;
        BasicHyperlinkUI.ICON_RECT.x = 0;
        Icon icon = BasicHyperlinkUI.getIcon(b);
        String text = SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), VIEW_RECT, ICON_RECT, TEXT_RECT, b.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (icon != null) {
            this.paintIcon(g, b, ICON_RECT);
        }
        if (text != null && text.length() != 0) {
            View v = (View)b.getClientProperty("html");
            if (v != null) {
                v.paint(g, TEXT_RECT);
            } else {
                this.paintText(g, b, TEXT_RECT, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, VIEW_RECT, TEXT_RECT, ICON_RECT);
        }
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRectangle) {
        JGHyperlink b = (JGHyperlink)c;
        ButtonModel model = b.getModel();
        Icon icon = BasicHyperlinkUI.getIcon(b);
        Icon tmpIcon = null;
        if (icon == null) {
            return;
        }
        if (!model.isEnabled()) {
            tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon != null) {
                this.clearTextShiftOffset();
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b.getSelectedIcon();
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        icon.paintIcon(c, g, iconRectangle.x, iconRectangle.y);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRectangle, String text) {
        JGHyperlink link = (JGHyperlink)b;
        if (b.isEnabled()) {
            boolean underline;
            super.paintText(g, b, textRectangle, text);
            ButtonModel model = b.getModel();
            boolean bl = underline = !b.isRolloverEnabled() || model.isRollover() || model.isPressed();
            if (underline) {
                FontMetrics fm = b.getFontMetrics(b.getFont());
                boolean visited = link.getVisited() && link.isVisitedEnabled();
                g.setColor(visited ? link.getVisitedForeground() : b.getForeground());
                g.fillRect(textRectangle.x, textRectangle.y + fm.getAscent() + 1, textRectangle.width, 1);
            }
        } else {
            ++textRectangle.x;
            ++textRectangle.y;
            super.paintText(g, b, textRectangle, text);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRectangle, Rectangle textRectangle, Rectangle iconRectangle) {
        int width = b.getWidth();
        int height = b.getHeight();
        int x = 0;
        int y = 0;
        int w = width;
        int h = height;
        Color focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        g.setColor(focusColor);
        BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
    }

    private static Icon getIcon(JGHyperlink link) {
        return link.isIconVisible() ? link.getIcon() : null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        return BasicHyperlinkUI.getPreferredButtonSize(b, b.getIconTextGap());
    }

    private static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap) {
        Icon icon = BasicHyperlinkUI.getIcon((JGHyperlink)b);
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        BasicHyperlinkUI.VIEW_RECT.y = 0;
        BasicHyperlinkUI.VIEW_RECT.x = 0;
        BasicHyperlinkUI.VIEW_RECT.height = Short.MAX_VALUE;
        BasicHyperlinkUI.VIEW_RECT.width = Short.MAX_VALUE;
        BasicHyperlinkUI.TEXT_RECT.height = 0;
        BasicHyperlinkUI.TEXT_RECT.width = 0;
        BasicHyperlinkUI.TEXT_RECT.y = 0;
        BasicHyperlinkUI.TEXT_RECT.x = 0;
        BasicHyperlinkUI.ICON_RECT.height = 0;
        BasicHyperlinkUI.ICON_RECT.width = 0;
        BasicHyperlinkUI.ICON_RECT.y = 0;
        BasicHyperlinkUI.ICON_RECT.x = 0;
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), VIEW_RECT, ICON_RECT, TEXT_RECT, textIconGap);
        Rectangle r = ICON_RECT.union(TEXT_RECT);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        return r.getSize();
    }

    static {
        VIEW_RECT = new Rectangle();
        TEXT_RECT = new Rectangle();
        ICON_RECT = new Rectangle();
    }

    private static final class Handler
    extends BasicButtonListener {
        Handler(JGHyperlink link) {
            super(link);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            AbstractButton b = (AbstractButton)evt.getSource();
            b.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            AbstractButton b = (AbstractButton)evt.getSource();
            b.setCursor(null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "visited": 
                case "visitedEnabled": 
                case "visitedForeground": {
                    Color foreground;
                    JGHyperlink link = (JGHyperlink)evt.getSource();
                    boolean visitedActive = link.getVisited() && link.isVisitedEnabled();
                    Color color = foreground = visitedActive ? link.getVisitedForeground() : link.getForeground();
                    if (link.getForeground() instanceof ColorUIResource) {
                        link.setForeground(foreground);
                    }
                    BasicHTML.updateRenderer(link, link.getText());
                    break;
                }
                default: {
                    super.propertyChange(evt);
                }
            }
        }
    }
}

