/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.manager;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import jrm.locale.Messages;

public final class ProfileNFOMame
implements Serializable {
    private static final long serialVersionUID = 1L;
    private File file = null;
    private Long modified = null;
    private boolean sl = false;
    public File fileroms = null;
    public File filesl = null;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("file", File.class), new ObjectStreamField("modified", Long.class), new ObjectStreamField("sl", Boolean.TYPE), new ObjectStreamField("fileroms", File.class), new ObjectStreamField("filesl", File.class)};

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("file", this.file);
        fields.put("modified", this.modified);
        fields.put("sl", this.sl);
        fields.put("fileroms", this.fileroms);
        fields.put("filesl", this.filesl);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.file = (File)fields.get("file", null);
        this.modified = (Long)fields.get("modified", null);
        this.sl = fields.get("sl", false);
        this.fileroms = (File)fields.get("fileroms", null);
        this.filesl = (File)fields.get("filesl", null);
    }

    public void set(File mame, boolean sl) {
        if (mame.exists()) {
            this.file = mame;
            this.modified = mame.lastModified();
            this.sl = sl;
        }
    }

    public MameStatus getStatus() {
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.lastModified() > this.modified) {
                    return MameStatus.NEEDUPDATE;
                }
                if (!this.fileroms.exists()) {
                    return MameStatus.NEEDUPDATE;
                }
                if (this.isSL() && !this.filesl.exists()) {
                    return MameStatus.NEEDUPDATE;
                }
                return MameStatus.UPTODATE;
            }
            return MameStatus.NOTFOUND;
        }
        return MameStatus.UNKNOWN;
    }

    public File getFile() {
        return this.file;
    }

    public void setUpdated() {
        this.modified = this.file.lastModified();
    }

    public MameStatus relocate(File newFile) {
        if (this.file != null && newFile != null) {
            if (newFile.exists()) {
                this.file = newFile;
                if (this.file.lastModified() > this.modified) {
                    return MameStatus.NEEDUPDATE;
                }
                return MameStatus.UPTODATE;
            }
            return MameStatus.NOTFOUND;
        }
        return MameStatus.UNKNOWN;
    }

    public boolean isSL() {
        return this.sl;
    }

    public void delete() {
        if (this.fileroms != null) {
            this.fileroms.delete();
        }
        if (this.filesl != null) {
            this.filesl.delete();
        }
    }

    public static enum MameStatus {
        UNKNOWN(Messages.getString("ProfileNFOMame.Unknown")),
        UPTODATE(Messages.getString("ProfileNFOMame.UpToDate")),
        NEEDUPDATE(Messages.getString("ProfileNFOMame.NeedUpdate")),
        NOTFOUND(Messages.getString("ProfileNFOMame.NotFound"));

        private final String msg;

        private MameStatus(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

