/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.victory;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import megamek.common.Report;
import megamek.server.victory.Victory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VictoryResult
implements Victory.Result {
    protected boolean victory;
    protected Throwable tr;
    protected ArrayList<Report> reports = new ArrayList();
    protected HashMap<Integer, Double> playerScore = new HashMap();
    protected HashMap<Integer, Double> teamScore = new HashMap();
    protected double hiScore = 0.0;

    public VictoryResult(boolean bl) {
        this.victory = bl;
        this.tr = new Throwable();
    }

    @Override
    public int getWinningPlayer() {
        double d = Double.MIN_VALUE;
        int n = -1;
        boolean bl = false;
        for (int n2 : this.playerScore.keySet()) {
            if (this.playerScore.get(n2) == d) {
                bl = true;
            }
            if (!(this.playerScore.get(n2) > d)) continue;
            bl = false;
            d = this.playerScore.get(n2);
            n = n2;
        }
        if (bl) {
            return -1;
        }
        return n;
    }

    @Override
    public int getWinningTeam() {
        double d = Double.MIN_VALUE;
        int n = 0;
        boolean bl = false;
        for (int n2 : this.teamScore.keySet()) {
            if (this.teamScore.get(n2) == d) {
                bl = true;
            }
            if (!(this.teamScore.get(n2) > d)) continue;
            bl = false;
            d = this.teamScore.get(n2);
            n = n2;
        }
        if (bl) {
            return 0;
        }
        return n;
    }

    protected void updateHiScore() {
        this.hiScore = Double.MIN_VALUE;
        for (Double d : this.playerScore.values()) {
            if (!(d > this.hiScore)) continue;
            this.hiScore = d;
        }
        for (Double d : this.teamScore.values()) {
            if (!(d > this.hiScore)) continue;
            this.hiScore = d;
        }
    }

    public void addPlayerScore(int n, double d) {
        this.playerScore.put(n, d);
        this.updateHiScore();
    }

    public void addTeamScore(int n, double d) {
        this.teamScore.put(n, d);
        this.updateHiScore();
    }

    @Override
    public boolean isWinningPlayer(int n) {
        double d = this.getPlayerScore(n);
        return d * 100.0 % 100.0 == this.hiScore * 100.0 % 100.0;
    }

    @Override
    public boolean isWinningTeam(int n) {
        double d = this.getTeamScore(n);
        return d * 100.0 % 100.0 == this.hiScore * 100.0 % 100.0;
    }

    @Override
    public boolean victory() {
        return this.victory;
    }

    public void setVictory(boolean bl) {
        this.victory = bl;
    }

    @Override
    public double getPlayerScore(int n) {
        if (this.playerScore.get(n) == null) {
            return 0.0;
        }
        return this.playerScore.get(n);
    }

    @Override
    public int[] getPlayers() {
        return this.intify(this.playerScore.keySet().toArray(new Integer[0]));
    }

    @Override
    public double getTeamScore(int n) {
        if (this.teamScore.get(n) == null) {
            return 0.0;
        }
        return this.teamScore.get(n);
    }

    @Override
    public int[] getTeams() {
        return this.intify(this.teamScore.keySet().toArray(new Integer[0]));
    }

    public void addReport(Report report) {
        this.reports.add(report);
    }

    @Override
    public ArrayList<Report> getReports() {
        return this.reports;
    }

    protected String getTrace() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.tr.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private int[] intify(Integer[] integerArray) {
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public String toString() {
        return "victory provided to you by:" + this.getTrace();
    }

    @Override
    public boolean isDraw() {
        return this.getWinningPlayer() == -1 && this.getWinningTeam() == 0;
    }
}

