/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import java.util.Enumeration;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class HelpCommand
extends ServerCommand {
    public HelpCommand(Server server) {
        super(server, "help", "Lists all of the commands available, or gives help on a specific command.  Usage: /help [command]");
    }

    public void run(int n, String[] stringArray) {
        if (stringArray.length == 1) {
            this.server.sendServerChat(n, "Type /help [command] for help on a specific command.  Commands available: " + this.commandList());
        } else {
            ServerCommand serverCommand = this.server.getCommand(stringArray[1]);
            if (serverCommand == null) {
                this.server.sendServerChat(n, "Command \"" + stringArray[1] + "\" not recognized.  Commands available: " + this.commandList());
            } else {
                this.server.sendServerChat(n, "/" + serverCommand.getName() + " : " + serverCommand.getHelp());
            }
        }
    }

    private String commandList() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<String> enumeration = this.server.getAllCommandNames();
        while (enumeration.hasMoreElements()) {
            ServerCommand serverCommand = this.server.getCommand(enumeration.nextElement());
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(serverCommand.getName());
        }
        return stringBuffer.toString();
    }
}

