/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.LBXHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPodHandler
extends LBXHandler {
    private static final long serialVersionUID = -1591751929178217495L;

    public MPodHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        int n = 15;
        if (this.nRange == 2) {
            n = 10;
        } else if (this.nRange == 3) {
            n = 5;
        } else if (this.nRange == 4) {
            n = 2;
        }
        int n2 = 0;
        if (this.bGlancing) {
            n2 = 4;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n2 -= 2;
        }
        int n3 = this.allShotsHit() ? n : Compute.missilesHit(n, n2);
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n3);
        this.r.add(" pellet(s) ");
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n3;
    }
}

