/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.IGame;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.LRMAntiTSMHandler;
import megamek.common.weapons.LRMDeadFireHandler;
import megamek.common.weapons.LRMFollowTheLeaderHandler;
import megamek.common.weapons.LRMFragHandler;
import megamek.common.weapons.LRMHandler;
import megamek.common.weapons.LRMScatterableHandler;
import megamek.common.weapons.LRMSwarmHandler;
import megamek.common.weapons.LRMSwarmIHandler;
import megamek.common.weapons.MissileWeapon;
import megamek.common.weapons.SRMAXHandler;
import megamek.common.weapons.SRMAntiTSMHandler;
import megamek.common.weapons.SRMDeadFireHandler;
import megamek.common.weapons.SRMFragHandler;
import megamek.common.weapons.SRMHandler;
import megamek.common.weapons.SRMInfernoHandler;
import megamek.common.weapons.SRMTandemChargeHandler;
import megamek.server.Server;

public abstract class MMLWeapon
extends MissileWeapon {
    private static final long serialVersionUID = 110779423352325731L;

    public MMLWeapon() {
        this.ammoType = 45;
        this.setModes(new String[]{"", "Indirect"});
        this.atClass = 12;
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        AmmoType ammoType = (AmmoType)iGame.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId()).getLinked().getType();
        if (ammoType.hasFlag(32L)) {
            if (ammoType.getMunitionType() == 512L) {
                return new LRMFragHandler(toHitData, weaponAttackAction, iGame, server);
            }
            if (ammoType.getMunitionType() == 2048L) {
                return new LRMAntiTSMHandler(toHitData, weaponAttackAction, iGame, server);
            }
            if (ammoType.getMunitionType() == 0x400000L || ammoType.getMunitionType() == 0x4000000L || ammoType.getMunitionType() == 0x800000L || ammoType.getMunitionType() == 0x1000000L || ammoType.getMunitionType() == 0x2000000L) {
                return new LRMScatterableHandler(toHitData, weaponAttackAction, iGame, server);
            }
            if (ammoType.getMunitionType() == 0x100000L) {
                return new LRMSwarmHandler(toHitData, weaponAttackAction, iGame, server);
            }
            if (ammoType.getMunitionType() == 0x200000L) {
                return new LRMSwarmIHandler(toHitData, weaponAttackAction, iGame, server);
            }
            if (ammoType.getMunitionType() == 16384L) {
                return new LRMDeadFireHandler(toHitData, weaponAttackAction, iGame, server);
            }
            if (ammoType.getMunitionType() == 0x8000000L) {
                return new LRMFollowTheLeaderHandler(toHitData, weaponAttackAction, iGame, server);
            }
            return new LRMHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 512L) {
            return new SRMFragHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 0x40000000L) {
            return new SRMAXHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 2048L) {
            return new SRMAntiTSMHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 0x20000000L) {
            return new SRMInfernoHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 16384L) {
            return new SRMDeadFireHandler(toHitData, weaponAttackAction, iGame, server);
        }
        if (ammoType.getMunitionType() == 65536L) {
            return new SRMTandemChargeHandler(toHitData, weaponAttackAction, iGame, server);
        }
        return new SRMHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

