/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.LRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRMAntiTSMHandler
extends LRMHandler {
    private static final long serialVersionUID = 5702089152489814687L;

    public LRMAntiTSMHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " anti-TSM missile(s) ";
        this.damageType = Server.DamageType.ANTI_TSM;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            return 1;
        }
        int n2 = 0;
        boolean bl = false;
        if (this.ae instanceof Mech) {
            bl = this.ae.isStealthActive();
        }
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.game.getOptions().booleanOption("tacops_range") && this.nRange > this.wtype.getRanges(this.weapon)[3]) {
            n2 -= 2;
        }
        if (this.bDirect) {
            n2 += this.toHit.getMoS() / 3 * 2;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n2 -= 2;
        }
        n2 += this.getAMSHitsMod(vector);
        if (this.allShotsHit()) {
            n = this.wtype.getRackSize();
        } else {
            n = Compute.missilesHit(this.wtype.getRackSize(), n2, this.bGlancing);
            n = (int)Math.ceil((double)n / 2.0);
        }
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n);
        this.r.add(this.sSalvoType);
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        if (bl) {
            this.r = new Report(3335);
            this.r.subject = this.subjectId;
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        if (n2 != 0) {
            this.r = n2 > 0 ? new Report(3340) : new Report(3341);
            this.r.subject = this.subjectId;
            this.r.add(n2);
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }
}

