/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

public class ManeuverType {
    public static final int MAN_NONE = 0;
    public static final int MAN_LOOP = 1;
    public static final int MAN_IMMELMAN = 2;
    public static final int MAN_SPLIT_S = 3;
    public static final int MAN_HAMMERHEAD = 4;
    public static final int MAN_HALF_ROLL = 5;
    public static final int MAN_BARREL_ROLL = 6;
    public static final int MAN_SIDE_SLIP_LEFT = 7;
    public static final int MAN_SIDE_SLIP_RIGHT = 8;
    public static final int MAN_VIFF = 9;
    private static String[] names = new String[]{"None", "Loop", "Immelman", "Split S", "Hammerhead", "Half Roll", "Barrel Roll", "Side Slip (Left)", "Side Slip (Right)", "VIFF"};
    public static final int MAN_SIZE = names.length;

    public static String getTypeName(int n) {
        if (n >= 0 && n < MAN_SIZE) {
            return names[n];
        }
        throw new IllegalArgumentException("Unknown maneuver type");
    }

    public static boolean canPerform(int n, int n2, int n3, int n4, boolean bl, int n5) {
        if (n5 > 0 && n != 7 && n != 8) {
            return false;
        }
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return n2 >= 4;
            }
            case 2: {
                return n2 >= 3 && n3 < 9;
            }
            case 3: {
                return n3 + 2 > n4;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return n2 >= 2;
            }
            case 7: 
            case 8: {
                return n2 > 0;
            }
            case 9: {
                return bl;
            }
        }
        return false;
    }

    public static int getCost(int n, int n2) {
        switch (n) {
            case 1: {
                return 4;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return n2;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 7: 
            case 8: {
                return 1;
            }
            case 9: {
                return n2 + 2;
            }
        }
        return 0;
    }

    public static int getMod(int n, boolean bl) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return -1;
            }
            case 6: {
                return 0;
            }
            case 7: 
            case 8: {
                if (bl) {
                    return -1;
                }
                return 0;
            }
            case 9: {
                return 2;
            }
        }
        return 0;
    }
}

