/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.BipedMech;
import megamek.common.Coords;
import megamek.common.IHex;

public class LandAirMech
extends BipedMech {
    private static final long serialVersionUID = 3527907120230165939L;
    public static final int MODE_MECH = 1;
    public static final int MODE_AIRMECH = 2;
    public static final int MODE_AIRCRAFT = 4;
    public static final int MODE_CONVERT = 256;
    public static final int MODE_CONVERT_MECH_TO_AIRMECH = 274;
    public static final int MODE_CONVERT_MECH_TO_AIRCRAFT = 276;
    public static final int MODE_CONVERT_AIRMECH_TO_MECH = 289;
    public static final int MODE_CONVERT_AIRMECH_TO_AIRCRAFT = 292;
    public static final int MODE_CONVERT_AIRCRAFT_TO_MECH = 321;
    public static final int MODE_CONVERT_AIRCRAFT_TO_AIRMECH = 322;
    private int mode = 1;
    private int startMode = 1;
    private boolean landed = true;

    public LandAirMech(String string, String string2) {
        super(string, string2);
    }

    public LandAirMech() {
    }

    public LandAirMech(int n, int n2) {
        super(n, n2);
    }

    public int getElevation() {
        if (this.mode == 1) {
            return super.getElevation();
        }
        return this.elevation;
    }

    public boolean canGoUp(int n, Coords coords) {
        IHex iHex = this.getGame().getBoard().getHex(coords);
        int n2 = n + iHex.surface();
        int n3 = iHex.surface();
        if (this.mode == 2) {
            n3 += 50;
        } else if (this.mode == 4) {
            return true;
        }
        return n2 < n3;
    }

    public boolean canGoDown(int n, Coords coords) {
        IHex iHex = this.getGame().getBoard().getHex(coords);
        int n2 = n + iHex.surface();
        int n3 = iHex.surface();
        if (this.isInMode(4)) {
            n3 = iHex.ceiling();
            if (iHex.containsTerrain(1) || iHex.containsTerrain(2) || iHex.containsTerrain(5)) {
                ++n3;
            }
        } else if (this.isInMode(1)) {
            n3 = iHex.floor();
        }
        return n2 > n3;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isInMode(int n) {
        return this.mode == n;
    }

    public boolean canConvertToMech() {
        if (!this.isDeployed()) {
            return true;
        }
        if (this.startMode == 2 && this.landed && this.isSystemIntact(13) && this.isSystemIntact(12) && this.isSystemIntact(11) && this.isSystemIntact(4)) {
            return true;
        }
        return this.startMode == 1 && this.mode != this.startMode;
    }

    public boolean canConvertToAirmech() {
        if (!this.isDeployed()) {
            return true;
        }
        if (this.startMode == 1 && this.isSystemIntact(13) && this.isSystemIntact(12) && this.isSystemIntact(11) && this.isSystemIntact(4)) {
            return true;
        }
        if (this.startMode == 4 && this.isSystemIntact(13) && this.isSystemIntact(12)) {
            return true;
        }
        return this.startMode == 2 && this.mode != this.startMode;
    }

    public boolean canConvertToAircraft() {
        if (!this.isDeployed()) {
            return true;
        }
        if (!this.landed && this.startMode == 2 && this.isSystemIntact(13) && this.isSystemIntact(12) && this.isSystemIntact(7) && this.isSystemIntact(8)) {
            return true;
        }
        return this.startMode == 4 && this.mode != this.startMode;
    }

    public boolean canConvertToMode(int n) {
        switch (n) {
            case 1: {
                return this.canConvertToMech();
            }
            case 2: {
                return this.canConvertToAirmech();
            }
            case 4: {
                return this.canConvertToAircraft();
            }
        }
        throw new IllegalArgumentException("Not a valid mode.");
    }

    public void convertToMode(int n) {
        if (!this.isDeployed()) {
            this.startMode = this.mode = n;
            return;
        }
        if (this.startMode == n) {
            this.mode = this.startMode;
        } else if (this.canConvertToMode(n)) {
            switch (n) {
                case 1: {
                    this.mode = 289;
                    break;
                }
                case 2: {
                    if (this.startMode == 1) {
                        this.mode = 274;
                        break;
                    }
                    if (this.startMode != 4) break;
                    this.mode = 322;
                    break;
                }
                case 4: {
                    this.mode = 292;
                }
            }
        }
    }

    public int getMaxElevationChange() {
        if (this.mode == 1) {
            return super.getMaxElevationChange();
        }
        return 999;
    }

    public void newRound(int n) {
        if (this.mode >= 256) {
            switch (this.mode) {
                case 289: 
                case 321: {
                    this.mode = 1;
                    if (this.getElevation() > 0) {
                        // empty if block
                    }
                    this.setProne(true);
                    this.landed = true;
                    break;
                }
                case 274: 
                case 322: {
                    this.mode = 2;
                    break;
                }
                case 276: 
                case 292: {
                    this.mode = 4;
                    break;
                }
            }
        }
        this.startMode = this.mode;
        super.newRound(n);
    }

    public int getOriginalJumpMP() {
        int n = super.getOriginalJumpMP();
        switch (this.mode) {
            case 2: 
            case 292: {
                n *= 3;
                break;
            }
            case 289: {
                n = (int)((double)n * 1.5);
                break;
            }
            case 274: {
                n = (int)((double)n * 0.5);
                break;
            }
            case 4: 
            case 322: {
                return 0;
            }
        }
        return n;
    }

    public int getJumpHeat(int n) {
        if (this.mode == 1 || this.mode == 274) {
            return super.getJumpHeat(n);
        }
        return 0;
    }

    public boolean isEligibleForFiring() {
        if (this.mode == 292 || this.mode == 322) {
            return false;
        }
        return super.isEligibleForFiring();
    }

    public int getOriginalWalkMP() {
        int n = super.getOriginalWalkMP();
        switch (this.mode) {
            case 2: 
            case 292: {
                n = (int)Math.ceil((double)n / 3.0);
                break;
            }
            case 289: {
                n = (int)Math.ceil((double)n / 6.0);
                break;
            }
            case 274: {
                n = (int)Math.ceil((double)n / 2.0);
            }
        }
        return n;
    }

    public boolean isFlying() {
        return !this.landed;
    }

    public int getJumpMP() {
        return this.getOriginalJumpMP();
    }

    public int getJumpMPWithTerrain() {
        return this.getJumpMP();
    }
}

