/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import megamek.common.ASFBay;
import megamek.common.AmmoType;
import megamek.common.Bay;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.LightVehicleBay;
import megamek.common.MechBay;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.SmallCraft;
import megamek.common.SmallCraftBay;
import megamek.common.WeaponType;
import megamek.common.weapons.BayWeapon;

public class Dropship
extends SmallCraft
implements Serializable {
    private static final long serialVersionUID = 1528728632696989565L;
    int escapePods = 0;
    int lifeBoats = 0;
    private boolean dockCollarDamaged = false;

    public boolean isDockCollarDamaged() {
        return this.dockCollarDamaged;
    }

    public void setDamageDockCollar(boolean bl) {
        this.dockCollarDamaged = bl;
    }

    public void setEscapePods(int n) {
        this.escapePods = n;
    }

    public int getEscapePods() {
        return this.escapePods;
    }

    public void setLifeBoats(int n) {
        this.lifeBoats = n;
    }

    public int getLifeBoats() {
        return this.lifeBoats;
    }

    public int getFuelPerTon() {
        int n = 80;
        if (this.weight >= 40000.0f) {
            n = 10;
            return n;
        }
        if (this.weight >= 20000.0f) {
            n = 20;
            return n;
        }
        if (this.weight >= 3000.0f) {
            n = 30;
            return n;
        }
        if (this.weight >= 1900.0f) {
            n = 40;
            return n;
        }
        if (this.weight >= 1200.0f) {
            n = 50;
            return n;
        }
        if (this.weight >= 800.0f) {
            n = 60;
            return n;
        }
        if (this.weight >= 400.0f) {
            n = 70;
            return n;
        }
        return n;
    }

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        d += 10000.0;
        double d2 = 0.065;
        if (this.isClan()) {
            d2 = 0.061;
        }
        double d3 = (double)((float)this.getOriginalWalkMP() * this.weight) * d2;
        d += d3 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += (double)(200 * this.getFuel() / this.getFuelPerTon());
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        d += (double)this.getWeaponsAndEquipmentCost();
        int n2 = 0;
        int n3 = 0;
        for (Bay bay : this.getTransportBays()) {
            n2 += bay.getDoors();
            if (bay instanceof MechBay || bay instanceof ASFBay || bay instanceof SmallCraftBay) {
                n3 += 20000 * bay.totalSpace;
            }
            if (!(bay instanceof LightVehicleBay) && !(bay instanceof HeavyVehicleBay)) continue;
            n3 += 10000 * bay.totalSpace;
        }
        d += (double)(n3 + n2 * 1000);
        d += (double)(5000 * (this.getLifeBoats() + this.getEscapePods()));
        double d4 = 36.0;
        if (this.isSpheroid()) {
            d4 = 28.0;
        }
        return Math.round(d * d4);
    }

    public int calculateBattleValue(boolean bl, boolean bl2) {
        double d;
        double string;
        double n9;
        int hashMap;
        Object object;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x200000000000L)) continue;
            n2 += mounted.getBaseDamageCapacity() - mounted.getDamageTaken();
        }
        d4 += (double)(this.getTotalArmor() + n2) * 2.5;
        d4 += (double)this.getSI() * 2.0;
        double d6 = 0.0;
        for (Mounted serializable2 : this.getEquipment()) {
            object = serializable2.getType();
            if (serializable2.isDestroyed() || !(object instanceof WeaponType && ((EquipmentType)object).hasFlag(0x800000L) || object instanceof AmmoType && ((AmmoType)object).getAmmoType() == 14 || object instanceof AmmoType && ((AmmoType)object).getAmmoType() == 62) && (!(object instanceof WeaponType) || ((WeaponType)object).getAtClass() != 21)) continue;
            d6 += ((EquipmentType)object).getBV(this);
        }
        d4 += d6;
        d4 *= this.getBVTypeModifier();
        int n3 = this.getHeatCapacity();
        TreeMap<Object, Double> treeMap = new TreeMap<Object, Double>();
        object = new TreeMap();
        TreeMap<Integer, Double> treeMap2 = new TreeMap<Integer, Double>();
        for (Mounted mounted : this.getTotalWeaponList()) {
            Object d9;
            WeaponType n5 = (WeaponType)mounted.getType();
            double n6 = n5.getHeat();
            int d13 = this.getWeaponArc(this.getEquipmentNum(mounted));
            double d2 = n5.getBV(this);
            if (n5 instanceof BayWeapon || n5.hasFlag(0x800000L) || n5.getAtClass() == 21 || mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (n5.getAmmoType() == 20 || n5.getAmmoType() == 33) {
                n6 *= 2.0;
            }
            if (n5.getAmmoType() == 23) {
                n6 *= 6.0;
            }
            if (!(n5.hasFlag(131072L) && n5.getAmmoType() != 46 || n5.hasFlag(16384L) || n5.hasFlag(2048L) || n5.getAmmoType() == -1)) {
                d9 = n5.getAmmoType() + ":" + n5.getRackSize() + ";" + d13;
                if (!treeMap.containsKey(d9)) {
                    treeMap.put(d9, n5.getBV(this));
                } else {
                    treeMap.put(d9, n5.getBV(this) + (Double)treeMap.get(d9));
                }
            }
            if (n5.hasFlag(0x100000000L)) {
                double d3 = 0.0;
                for (Mounted d16 : this.getTotalWeaponList()) {
                    if (!d16.getType().hasFlag(512L) || d16.getLocation() != mounted.getLocation()) continue;
                    d3 += d16.getType().getBV(this);
                }
                d2 = d3 * 0.67;
            }
            if (n5.hasFlag(1L) && this.hasTargComp()) {
                d2 *= 1.25;
            }
            if (mounted.getLinkedBy() != null) {
                d9 = mounted.getLinkedBy();
                if (((Mounted)d9).getType() instanceof MiscType && ((Mounted)d9).getType().hasFlag(512L)) {
                    d2 *= 1.2;
                }
                if (((Mounted)d9).getType() instanceof MiscType && ((Mounted)d9).getType().hasFlag(0x1000000000000L)) {
                    d2 *= 1.15;
                }
            }
            double object2 = 0.0;
            double d7 = 0.0;
            if (null != ((TreeMap)object).get(d13)) {
                object2 = (Double)((TreeMap)object).get(d13);
            }
            if (null != treeMap2.get(d13)) {
                d7 = (Double)treeMap2.get(d13);
            }
            ((TreeMap)object).put(d13, object2 + d2);
            treeMap2.put(d13, d7 + n6);
        }
        double d8 = 0.0;
        int n = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        double d9 = 1.0;
        double d10 = 0.5;
        double d11 = 0.0;
        double d12 = 0.0;
        Set set = ((TreeMap)object).keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashMap = (Integer)iterator.next();
            if (!((Double)((TreeMap)object).get(hashMap) > d11)) continue;
            n = hashMap;
            d11 = (Double)((TreeMap)object).get(hashMap);
        }
        if (n > Integer.MIN_VALUE) {
            d12 += ((Double)treeMap2.get(n)).doubleValue();
            hashMap = this.getAdjacentArcCW(n);
            int arrayList = this.getAdjacentArcCCW(n);
            double d13 = 0.0;
            n9 = 0.0;
            if (hashMap > Integer.MIN_VALUE && null != ((TreeMap)object).get(hashMap)) {
                d13 = (Double)((TreeMap)object).get(hashMap);
                n9 = (Double)treeMap2.get(hashMap);
            }
            string = 0.0;
            double n12 = 0.0;
            if (arrayList > Integer.MIN_VALUE && null != ((TreeMap)object).get(arrayList)) {
                string = (Double)((TreeMap)object).get(arrayList);
                n12 = (Double)treeMap2.get(arrayList);
            }
            if (d13 > string) {
                n4 = hashMap;
                if (d12 + n9 > (double)n3) {
                    d9 = 0.5;
                }
                d12 += n9;
                n5 = arrayList;
                if (d12 + n12 > (double)n3) {
                    d10 = 0.25;
                }
            } else {
                n4 = arrayList;
                if (d12 + n12 > (double)n3) {
                    d9 = 0.5;
                }
                d12 += n12;
                n5 = hashMap;
                if (d12 + n9 > (double)n3) {
                    d10 = 0.25;
                }
            }
        }
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mounted mounted : this.getAmmo()) {
            int n6 = this.getWeaponArc(this.getEquipmentNum(mounted));
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || ammoType.getAmmoType() == 62 || mounted.getLocation() == -1) continue;
            String n10 = ammoType.getAmmoType() + ":" + ammoType.getRackSize() + ";" + n6;
            d = mounted.getShotsLeft() / ammoType.getShots();
            if (ammoType.isCapital()) {
                d = (double)mounted.getShotsLeft() * ammoType.getAmmoRatio();
            }
            if (!arrayList.contains(n10)) {
                arrayList.add(n10);
            }
            if (!hashMap2.containsKey(n10)) {
                hashMap2.put(n10, d * ammoType.getBV(this));
                continue;
            }
            hashMap2.put(n10, d * ammoType.getBV(this) + (Double)hashMap2.get(n10));
        }
        for (String string2 : arrayList) {
            n9 = 0.0;
            int miscType = Integer.parseInt(string2.split(";")[1]);
            if (treeMap.get(string2) != null) {
                n9 = (Double)hashMap2.get(string2) > (Double)treeMap.get(string2) ? (n9 += ((Double)treeMap.get(string2)).doubleValue()) : (n9 += ((Double)hashMap2.get(string2)).doubleValue());
            }
            d = 0.0;
            if (null != ((TreeMap)object).get(miscType)) {
                d = (Double)((TreeMap)object).get(miscType);
            }
            ((TreeMap)object).put(miscType, d + n9);
        }
        if (n > Integer.MIN_VALUE) {
            d8 += ((Double)((TreeMap)object).get(n)).doubleValue();
            ((TreeMap)object).put(n, 0.0);
            if (n4 > Integer.MIN_VALUE && null != ((TreeMap)object).get(n4)) {
                d8 += d9 * (Double)((TreeMap)object).get(n4);
                ((TreeMap)object).put(n4, 0.0);
            }
            if (n5 > Integer.MIN_VALUE && null != ((TreeMap)object).get(n5)) {
                d8 += d10 * (Double)((TreeMap)object).get(n5);
                ((TreeMap)object).put(n5, 0.0);
            }
            set = ((TreeMap)object).keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                int d19 = (Integer)iterator.next();
                d8 += 0.25 * (Double)((TreeMap)object).get(d19);
            }
        }
        double d14 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || miscType.hasFlag(1024L)) continue;
            d = miscType.getBV(this);
            d14 += d;
        }
        double d15 = Math.pow(1.0 + ((double)this.getRunMP() - 5.0) / 10.0, 1.2);
        d15 = (double)Math.round(d15 * 100.0) / 100.0;
        d5 = (d8 += d14) * d15;
        string = 0.0;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.c3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5) && !bl && this.game != null) {
            int n13 = 0;
            n13 += this.calculateBattleValue(true, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n13 += entity.calculateBattleValue(true, true);
            }
            n13 = (int)((double)n13 * 0.05);
            string += (double)n13;
        }
        int n7 = (int)Math.round(d4 + d5 + string);
        double d16 = 1.0;
        if (!bl2) {
            d16 = this.crew.getBVSkillMultiplier();
        }
        int n8 = (int)Math.round((double)n7 * d16);
        if (bl) {
            return n7;
        }
        return n8;
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted.getLocation() != mounted2.getLocation()) {
            return bl;
        }
        Mounted mounted3 = this.whichBay(this.getEquipmentNum(mounted));
        if (mounted3 != null && !mounted3.ammoInBay(this.getEquipmentNum(mounted2))) {
            return bl;
        }
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(16384L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }

    public int getHQIniBonus() {
        return 2;
    }

    public int getAdjacentArcCW(int n) {
        switch (n) {
            case 11: {
                if (this.isSpheroid()) {
                    return 17;
                }
                return 13;
            }
            case 12: {
                return 11;
            }
            case 13: {
                return 15;
            }
            case 14: {
                return 12;
            }
            case 15: {
                return 22;
            }
            case 16: {
                return 11;
            }
            case 17: {
                return 19;
            }
            case 18: {
                return 16;
            }
            case 19: {
                return 22;
            }
            case 22: {
                if (this.isSpheroid()) {
                    return 18;
                }
                return 14;
            }
        }
        return Integer.MIN_VALUE;
    }

    public int getAdjacentArcCCW(int n) {
        switch (n) {
            case 11: {
                if (this.isSpheroid()) {
                    return 16;
                }
                return 12;
            }
            case 12: {
                return 14;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 22;
            }
            case 15: {
                return 13;
            }
            case 16: {
                return 18;
            }
            case 17: {
                return 11;
            }
            case 18: {
                return 22;
            }
            case 19: {
                return 13;
            }
            case 22: {
                if (this.isSpheroid()) {
                    return 19;
                }
                return 15;
            }
        }
        return Integer.MIN_VALUE;
    }

    public boolean hasActiveECM() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.hasActiveECM();
        }
        return this.getECMRange() > -1;
    }

    public int getECMRange() {
        if (!this.game.getOptions().booleanOption("stratops_ecm") || !this.game.getBoard().inSpace()) {
            return super.getECMRange();
        }
        if (!this.isMilitary()) {
            return -1;
        }
        int n = 1;
        n = n - this.getFCSHits() - this.getSensorHits();
        return n;
    }
}

