/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.vecmath.Point3d;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.boardview3d.C3LinkModel;
import megamek.client.ui.AWT.boardview3d.EntityModel;
import megamek.client.ui.AWT.boardview3d.TileTextureManager;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.UnitLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntityGroup
extends BranchGroup {
    IGame game;
    ViewTransform currentView;
    TileTextureManager tileManager;
    HashMap<C3LinkModel, C3LinkModel> c3links = new HashMap();

    public EntityGroup(IGame iGame, TileTextureManager tileTextureManager, ViewTransform viewTransform) {
        this.game = iGame;
        this.tileManager = tileTextureManager;
        this.currentView = viewTransform;
        this.setCapability(14);
        this.setCapability(13);
        this.compile();
    }

    private EntityModel find(Entity entity) {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!(node instanceof EntityModel) || !entity.equals(node.getUserData())) continue;
            return (EntityModel)node;
        }
        return null;
    }

    public void move(Entity entity, Vector<UnitLocation> vector) {
        EntityModel entityModel = this.find(entity);
        if (vector.size() < 1 || entityModel == null) {
            this.update(entity, entityModel);
            return;
        }
        entityModel.move(entity, vector, this.game.getBoard());
        Coords coords = vector.elementAt(0).getCoords();
        this.currentView.centerOnHex(coords, this.game.getBoard().getHex(coords));
    }

    public boolean isMoving() {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof EntityModel) || !((EntityModel)((Object)e)).isMoving()) continue;
            return true;
        }
        return false;
    }

    public void remove(Entity entity) {
        EntityModel entityModel = this.find(entity);
        if (entityModel != null) {
            entityModel.detach();
        }
    }

    public void clear() {
        Enumeration enumeration = this.getAllChildren();
        while (enumeration.hasMoreElements()) {
            ((BranchGroup)enumeration.nextElement()).detach();
        }
    }

    public void update(Entity entity) {
        EntityModel entityModel = this.find(entity);
        this.update(entity, entityModel);
    }

    void removeC3LinksFor(Entity entity) {
        Vector<C3LinkModel> vector = new Vector<C3LinkModel>();
        for (C3LinkModel c3LinkModel : this.c3links.values()) {
            if (c3LinkModel.src.getId() != entity.getId() && c3LinkModel.dst.getId() != entity.getId()) continue;
            vector.add(c3LinkModel);
            c3LinkModel.detach();
        }
        for (C3LinkModel c3LinkModel : vector) {
            this.c3links.remove((Object)c3LinkModel);
        }
    }

    private void update(Entity entity, EntityModel entityModel) {
        IHex iHex;
        if (entityModel != null) {
            entityModel.detach();
        }
        if ((iHex = this.game.getBoard().getHex(entity.getPosition())) != null) {
            this.removeC3LinksFor(entity);
            this.addChild((Node)new EntityModel(entity, this.tileManager, this.currentView, this.game));
            if (entity.hasC3() || entity.hasC3i()) {
                this.addC3LinksFor(entity, null);
            }
        }
    }

    public void update() {
        this.clear();
        IBoard iBoard = this.game.getBoard();
        if (iBoard == null) {
            return;
        }
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            this.update(enumeration.nextElement(), null);
        }
        if (GUIPreferences.getInstance().getShowWrecks()) {
            enumeration = this.game.getWreckedEntities();
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                if (entity instanceof Infantry) continue;
                this.update(entity, null);
            }
        }
    }

    void addC3LinksFor(Entity entity, Point3d point3d) {
        if (entity.getPosition() == null) {
            return;
        }
        if (entity.hasC3i()) {
            Enumeration<Entity> enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                C3LinkModel c3LinkModel;
                Entity entity2 = enumeration.nextElement();
                if (entity2.getPosition() == null || !entity.onSameC3NetworkAs(entity2) || entity2.equals(entity) || Compute.isAffectedByECM(entity, entity.getPosition(), entity2.getPosition()) || this.c3links.containsKey((Object)(c3LinkModel = new C3LinkModel(entity, entity2, this.game, point3d)))) continue;
                this.addChild((Node)c3LinkModel);
                this.c3links.put(c3LinkModel, c3LinkModel);
            }
        } else if (entity.getC3Master() != null) {
            C3LinkModel c3LinkModel;
            Entity entity3 = entity.getC3Master();
            if (entity3.getPosition() == null) {
                return;
            }
            if (!(Compute.isAffectedByECM(entity, entity.getPosition(), entity3.getPosition()) || Compute.isAffectedByECM(entity3, entity3.getPosition(), entity3.getPosition()) || this.c3links.containsKey((Object)(c3LinkModel = new C3LinkModel(entity, entity3, this.game, point3d))))) {
                this.addChild((Node)c3LinkModel);
                this.c3links.put(c3LinkModel, c3LinkModel);
            }
        }
    }

    void setView(ViewTransform viewTransform) {
        this.currentView = viewTransform;
        this.update();
    }
}

