/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import java.util.Map;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidationAction;

public enum ValidationActions implements ValidationAction
{
    NO_OP{

        @Override
        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
        }
    }
    ,
    INPUT_FILE_VALIDATOR{

        @Override
        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            File file = ValidationActions.toFile(context, value);
            if (!file.exists()) {
                context.recordValidationMessage(severity, String.format("File '%s' specified for property '%s' does not exist.", file, propertyName));
            } else if (!file.isFile()) {
                context.recordValidationMessage(severity, String.format("File '%s' specified for property '%s' is not a file.", file, propertyName));
            }
        }
    }
    ,
    INPUT_DIRECTORY_VALIDATOR{

        @Override
        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            File directory = ValidationActions.toDirectory(context, value);
            if (!directory.exists()) {
                context.recordValidationMessage(severity, String.format("Directory '%s' specified for property '%s' does not exist.", directory, propertyName));
            } else if (!directory.isDirectory()) {
                context.recordValidationMessage(severity, String.format("Directory '%s' specified for property '%s' is not a directory.", directory, propertyName));
            }
        }
    }
    ,
    OUTPUT_DIRECTORY_VALIDATOR{

        @Override
        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            File directory = ValidationActions.toFile(context, value);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    context.recordValidationMessage(severity, String.format("Directory '%s' specified for property '%s' is not a directory.", directory, propertyName));
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    context.recordValidationMessage(severity, String.format("Cannot write to directory '%s' specified for property '%s', as ancestor '%s' is not a directory.", directory, propertyName, candidate));
                    return;
                }
            }
        }
    }
    ,
    OUTPUT_DIRECTORIES_VALIDATOR{

        @Override
        public void validate(String propertyName, Object values, TaskValidationContext context, TaskValidationContext.Severity severity) {
            for (File directory : ValidationActions.toFiles(context, values)) {
                OUTPUT_DIRECTORY_VALIDATOR.validate(propertyName, directory, context, severity);
            }
        }
    }
    ,
    OUTPUT_FILE_VALIDATOR{

        @Override
        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            block2: {
                File file;
                block1: {
                    file = ValidationActions.toFile(context, value);
                    if (!file.exists()) break block1;
                    if (!file.isDirectory()) break block2;
                    context.recordValidationMessage(severity, String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", file, propertyName));
                    break block2;
                }
                for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    context.recordValidationMessage(severity, String.format("Cannot write to file '%s' specified for property '%s', as ancestor '%s' is not a directory.", file, propertyName, candidate));
                    break;
                }
            }
        }
    }
    ,
    OUTPUT_FILES_VALIDATOR{

        @Override
        public void validate(String propertyName, Object values, TaskValidationContext context, TaskValidationContext.Severity severity) {
            for (File file : ValidationActions.toFiles(context, values)) {
                OUTPUT_FILE_VALIDATOR.validate(propertyName, file, context, severity);
            }
        }
    };


    private static File toDirectory(TaskValidationContext context, Object value) {
        if (value instanceof ConfigurableFileTree) {
            return ((ConfigurableFileTree)value).getDir();
        }
        return ValidationActions.toFile(context, value);
    }

    private static File toFile(TaskValidationContext context, Object value) {
        return context.getResolver().resolve(value);
    }

    private static Iterable<? extends File> toFiles(TaskValidationContext context, Object value) {
        if (value instanceof Map) {
            return ValidationActions.toFiles(context, ((Map)value).values());
        }
        if (value instanceof FileCollection) {
            return (FileCollection)value;
        }
        return context.getResolver().resolveFiles(value);
    }
}

