/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPage;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public abstract class AbstractIntroElement
implements Cloneable {
    public static final int MODEL_ROOT = 1;
    public static final int PRESENTATION = 2;
    public static final int HOME_PAGE = 4;
    public static final int PAGE = 8;
    public static final int ABSTRACT_PAGE = 12;
    public static final int GROUP = 16;
    public static final int ABSTRACT_CONTAINER = 29;
    public static final int HTML = 32;
    public static final int LINK = 64;
    public static final int ABSTRACT_TEXT = 96;
    public static final int IMAGE = 128;
    public static final int INCLUDE = 256;
    public static final int TEXT = 512;
    public static final int CONTAINER_EXTENSION = 1024;
    public static final int HEAD = 2048;
    public static final int PAGE_TITLE = 4096;
    public static final int ANCHOR = 8192;
    public static final int BASE_ELEMENT = 4861;
    public static final int ID_ELEMENT = 13053;
    public static final int ELEMENT = 16383;
    private AbstractIntroElement parent;
    private IConfigurationElement cfgElement;
    private Bundle bundle;

    AbstractIntroElement(IConfigurationElement element) {
        this.cfgElement = element;
        this.bundle = ModelLoaderUtil.getBundleFromConfigurationElement(this.cfgElement);
    }

    AbstractIntroElement(Element element, Bundle bundle) {
        this.bundle = bundle;
    }

    public IConfigurationElement getCfgElement() {
        return this.cfgElement;
    }

    protected String getAttribute(Element element, String att) {
        if (element.hasAttribute(att)) {
            return element.getAttribute(att);
        }
        return null;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public abstract int getType();

    public AbstractIntroElement getParent() {
        return this.parent;
    }

    protected void setParent(AbstractIntroElement parent) {
        this.parent = parent;
    }

    public AbstractIntroPage getParentPage() {
        if (this.isOfType(12)) {
            return (AbstractIntroPage)this;
        }
        AbstractIntroElement parent = this.getParent();
        if (parent == null) {
            return null;
        }
        while (parent != null && parent.getParent() != null && !parent.isOfType(12)) {
            parent = parent.getParent();
        }
        if (parent.isOfType(12)) {
            return (AbstractIntroPage)parent;
        }
        return null;
    }

    public boolean isOfType(int elementMask) {
        return (this.getType() & elementMask) != 0;
    }

    public static final boolean allElementsAreOfType(AbstractIntroElement[] elements, int elementMask) {
        if (elements.length == 0) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            AbstractIntroElement element = elements[i];
            if (element.isOfType(elementMask)) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

