/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup.containers;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.launching.sourcelookup.containers.PackageFragmentRootSourceContainer;

public class JavaSourceLookupParticipant
extends AbstractSourceLookupParticipant {
    private Map fDelegateContainers;
    static /* synthetic */ Class class$org$eclipse$jdt$debug$core$IJavaStackFrame;

    public String getSourceName(Object object) throws CoreException {
        if (object instanceof IAdaptable) {
            IJavaStackFrame frame = (IJavaStackFrame)((IAdaptable)object).getAdapter(class$org$eclipse$jdt$debug$core$IJavaStackFrame == null ? (class$org$eclipse$jdt$debug$core$IJavaStackFrame = JavaSourceLookupParticipant.class$("org.eclipse.jdt.debug.core.IJavaStackFrame")) : class$org$eclipse$jdt$debug$core$IJavaStackFrame);
            try {
                if (frame != null) {
                    if (frame.isObsolete()) {
                        return null;
                    }
                    String sourceName = frame.getSourcePath();
                    if (sourceName == null) {
                        sourceName = frame.getDeclaringTypeName();
                        int index = sourceName.lastIndexOf(46);
                        if (index < 0) {
                            index = 0;
                        }
                        if ((index = (sourceName = sourceName.replace('.', File.separatorChar)).indexOf(36)) >= 0) {
                            sourceName = sourceName.substring(0, index);
                        }
                        sourceName = sourceName.length() == 0 ? null : sourceName + ".java";
                    }
                    return sourceName;
                }
            }
            catch (DebugException e) {
                if (e.getStatus().getCode() == 100) {
                    return null;
                }
                throw e;
            }
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public void dispose() {
        Iterator iterator = this.fDelegateContainers.values().iterator();
        while (iterator.hasNext()) {
            ISourceContainer container = (ISourceContainer)iterator.next();
            container.dispose();
        }
        this.fDelegateContainers = null;
        super.dispose();
    }

    protected ISourceContainer getDelegateContainer(ISourceContainer container) {
        ISourceContainer delegate = (ISourceContainer)this.fDelegateContainers.get(container);
        if (delegate == null) {
            return container;
        }
        return delegate;
    }

    public void init(ISourceLookupDirector director) {
        super.init(director);
        this.fDelegateContainers = new HashMap();
    }

    public void sourceContainersChanged(ISourceLookupDirector director) {
        this.fDelegateContainers.clear();
        ISourceContainer[] containers = director.getSourceContainers();
        for (int i = 0; i < containers.length; ++i) {
            IFile file;
            IProject project;
            IJavaProject javaProject;
            ISourceContainer container = containers[i];
            if (!container.getType().getId().equals(ArchiveSourceContainer.TYPE_ID) || !(javaProject = JavaCore.create((IProject)(project = (file = ((ArchiveSourceContainer)container).getFile()).getProject()))).exists()) continue;
            try {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                for (int j = 0; j < roots.length; ++j) {
                    IPackageFragmentRoot root = roots[j];
                    if (file.equals(root.getUnderlyingResource())) {
                        this.fDelegateContainers.put(container, new PackageFragmentRootSourceContainer(root));
                        continue;
                    }
                    IPath path = root.getSourceAttachmentPath();
                    if (path == null || !file.getFullPath().equals(path)) continue;
                    this.fDelegateContainers.put(container, new PackageFragmentRootSourceContainer(root));
                }
                continue;
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

