/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IMatchRules;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.IdentifiableObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.w3c.dom.Node;

public class FeatureChild
extends IdentifiableObject
implements IFeatureChild {
    private String version;
    private IFeature feature;
    private String name;
    private boolean optional;
    private int searchLocation = 0;
    private int match = 0;
    private String os;
    private String ws;
    private String arch;

    protected void reset() {
        super.reset();
        this.version = null;
        this.optional = false;
        this.name = null;
        this.searchLocation = 0;
        this.match = 0;
        this.os = null;
        this.ws = null;
        this.arch = null;
    }

    protected void parse(Node node, Hashtable lineTable) {
        String searchLocationName;
        super.parse(node, lineTable);
        this.bindSourceLocation(node, lineTable);
        this.version = this.getNodeAttribute(node, "version");
        this.name = this.getNodeAttribute(node, "name");
        this.optional = this.getBooleanAttribute(node, "optional");
        this.os = this.getNodeAttribute(node, "os");
        this.ws = this.getNodeAttribute(node, "ws");
        this.arch = this.getNodeAttribute(node, "arch");
        String matchName = this.getNodeAttribute(node, "match");
        if (matchName != null) {
            for (int i = 0; i < IMatchRules.RULE_NAME_TABLE.length; ++i) {
                if (!matchName.equals(IMatchRules.RULE_NAME_TABLE[i])) continue;
                this.match = i;
                break;
            }
        }
        if ((searchLocationName = this.getNodeAttribute(node, "search_location")) == null) {
            searchLocationName = this.getNodeAttribute(node, "search-location");
        }
        if (searchLocationName != null) {
            if (searchLocationName.equals("root")) {
                this.searchLocation = 0;
            } else if (searchLocationName.equals("self")) {
                this.searchLocation = 1;
            } else if (searchLocationName.equals("both")) {
                this.searchLocation = 2;
            }
        }
        this.hookWithWorkspace();
    }

    public void loadFrom(IFeature feature) {
        this.id = feature.getId();
        this.version = feature.getVersion();
        this.optional = false;
        this.name = feature.getLabel();
        this.feature = feature;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getName() {
        return this.name;
    }

    public int getSearchLocation() {
        return this.searchLocation;
    }

    public int getMatch() {
        return this.match;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getArch() {
        return this.arch;
    }

    public IFeature getReferencedFeature() {
        if (this.feature == null) {
            this.hookWithWorkspace();
        }
        return this.feature;
    }

    public void hookWithWorkspace() {
        IFeatureModel[] models = PDECore.getDefault().getWorkspaceModelManager().getFeatureModels();
        for (int i = 0; i < models.length; ++i) {
            IFeature feature = models[i].getFeature();
            if (feature == null || !feature.getId().equals(this.getId()) || this.version != null && !feature.getVersion().equals(this.version)) continue;
            this.feature = feature;
            break;
        }
    }

    public void setVersion(String version) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.version;
        this.version = version;
        this.firePropertyChanged("version", oldValue, version);
        this.hookWithWorkspace();
    }

    public void setName(String name) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChanged("name", oldValue, name);
    }

    public void setMatch(int match) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.match);
        this.match = match;
        this.firePropertyChanged("match", oldValue, new Integer(match));
    }

    public void setSearchLocation(int searchLocation) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.searchLocation);
        this.searchLocation = searchLocation;
        this.firePropertyChanged("search-location", oldValue, new Integer(searchLocation));
    }

    public void setOptional(boolean optional) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.optional);
        this.optional = optional;
        this.firePropertyChanged("name", oldValue, new Boolean(optional));
    }

    public void setOS(String os) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.os;
        this.os = os;
        this.firePropertyChanged("os", oldValue, os);
    }

    public void setWS(String ws) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.ws;
        this.ws = ws;
        this.firePropertyChanged("ws", oldValue, ws);
    }

    public void setArch(String arch) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.arch;
        this.arch = arch;
        this.firePropertyChanged("arch", oldValue, arch);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("version")) {
            this.setVersion((String)newValue);
        } else if (name.equals("optional")) {
            this.setOptional((Boolean)newValue);
        } else if (name.equals("name")) {
            this.setName((String)newValue);
        } else if (name.equals("match")) {
            this.setMatch(newValue != null ? (Integer)newValue : 0);
        } else if (name.equals("os")) {
            this.setOS((String)newValue);
        } else if (name.equals("ws")) {
            this.setWS((String)newValue);
        } else if (name.equals("arch")) {
            this.setArch((String)newValue);
        } else if (name.equals("search-location")) {
            this.setSearchLocation(newValue != null ? (Integer)newValue : 0);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public void setId(String id) throws CoreException {
        super.setId(id);
        this.hookWithWorkspace();
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(indent + "<includes");
        String indent2 = indent + "   " + "   ";
        if (this.getId() != null) {
            writer.println();
            writer.print(indent2 + "id=\"" + this.getId() + "\"");
        }
        if (this.getVersion() != null) {
            writer.println();
            writer.print(indent2 + "version=\"" + this.getVersion() + "\"");
        }
        if (this.getName() != null) {
            writer.println();
            writer.print(indent2 + "name=\"" + this.getName() + "\"");
        }
        if (this.isOptional()) {
            writer.println();
            writer.print(indent2 + "optional=\"true\"");
        }
        if (this.match != 0) {
            writer.println();
            writer.print(indent2 + "match=\"" + IMatchRules.RULE_NAME_TABLE[this.match] + "\"");
        }
        if (this.getOS() != null) {
            writer.println();
            writer.print(indent2 + "os=\"" + this.getOS() + "\"");
        }
        if (this.getWS() != null) {
            writer.println();
            writer.print(indent2 + "ws=\"" + this.getWS() + "\"");
        }
        if (this.getArch() != null) {
            writer.println();
            writer.print(indent2 + "arch=\"" + this.getArch() + "\"");
        }
        if (this.searchLocation != 0) {
            writer.println();
            String value = this.searchLocation == 1 ? "self" : "both";
            writer.print(indent2 + "search_location=\"" + value + "\"");
        }
        writer.println("/>");
    }
}

