/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.registry.MarkerQueryResult;

public class MarkerQuery {
    private String type;
    private String[] attributes;
    private int hashCode;

    public MarkerQuery(String markerType, String[] markerAttributes) {
        if (markerAttributes == null) {
            throw new IllegalArgumentException();
        }
        this.type = markerType;
        this.attributes = markerAttributes;
        this.computeHashCode();
    }

    public MarkerQueryResult performQuery(IMarker marker) {
        try {
            if (this.type != null && !this.type.equals(marker.getType())) {
                return null;
            }
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log("Error accessing marker type", e.getStatus());
            return null;
        }
        String[] values = new String[this.attributes.length];
        for (int i = 0; i < this.attributes.length; ++i) {
            try {
                Object value = marker.getAttribute(this.attributes[i]);
                if (value == null) {
                    return null;
                }
                values[i] = value.toString();
                continue;
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Error accessing marker attribute", e.getStatus());
                return null;
            }
        }
        return new MarkerQueryResult(values);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MarkerQuery)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        MarkerQuery mq = (MarkerQuery)o;
        if (!(this.type != null ? this.type.equals(mq.type) : mq.type == null)) {
            return false;
        }
        if (this.attributes.length != mq.attributes.length) {
            return false;
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i].equals(mq.attributes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void computeHashCode() {
        this.hashCode = 19;
        if (this.type != null) {
            this.hashCode = this.hashCode * 37 + this.type.hashCode();
        }
        for (int i = 0; i < this.attributes.length; ++i) {
            this.hashCode = this.hashCode * 37 + this.attributes[i].hashCode();
        }
    }

    public String getType() {
        return this.type;
    }

    public String[] getAttributes() {
        return this.attributes;
    }
}

