/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.TeamStatus;
import org.eclipse.team.core.subscribers.ISubscriberChangeEvent;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.IResourceVariantTree;
import org.eclipse.team.core.variants.PersistantResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSSyncTreeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.IResourceStateChangeListener;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSBaseResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSDescendantResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSResourceVariantTree;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;

public class CVSWorkspaceSubscriber
extends CVSSyncTreeSubscriber
implements IResourceStateChangeListener {
    private CVSResourceVariantTree baseTree;
    private CVSResourceVariantTree remoteTree;
    private static final String REMOTE_RESOURCE_KEY = "remote-resource-key";

    CVSWorkspaceSubscriber(QualifiedName id, String name, String description) {
        super(id, name, description);
        CVSBaseResourceVariantTree baseSynchronizer = new CVSBaseResourceVariantTree();
        this.baseTree = new CVSResourceVariantTree(baseSynchronizer, null, this.getCacheFileContentsHint()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IResource[] refresh(IResource[] resources, int depth, IProgressMonitor monitor) throws TeamException {
                try {
                    monitor.beginTask(null, 100);
                    IResource[] iResourceArray = new IResource[]{};
                    return iResourceArray;
                }
                finally {
                    monitor.done();
                }
            }
        };
        CVSDescendantResourceVariantByteStore remoteSynchronizer = new CVSDescendantResourceVariantByteStore(baseSynchronizer, new PersistantResourceVariantByteStore(new QualifiedName("org.eclipse.team.cvs", REMOTE_RESOURCE_KEY)));
        this.remoteTree = new CVSResourceVariantTree((ResourceVariantByteStore)remoteSynchronizer, null, this.getCacheFileContentsHint());
        ResourceStateChangeListeners.getListener().addResourceStateChangeListener(this);
    }

    public IResource[] roots() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            RepositoryProvider provider;
            IProject project = projects[i];
            if (!project.isOpen() || (provider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId())) == null) continue;
            result.add(project);
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void resourceSyncInfoChanged(IResource[] changedResources) {
        this.internalResourceSyncInfoChanged(changedResources, true);
    }

    private void internalResourceSyncInfoChanged(IResource[] changedResources, boolean canModifyWorkspace) {
        this.getRemoteByteStore().handleResourceChanges(changedResources, canModifyWorkspace);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])changedResources));
    }

    public void externalSyncInfoChange(IResource[] changedResources) {
        this.internalResourceSyncInfoChanged(changedResources, false);
    }

    public void resourceModified(IResource[] changedResources) {
    }

    public void projectConfigured(IProject project) {
        SubscriberChangeEvent delta = new SubscriberChangeEvent((Subscriber)this, 2, (IResource)project);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])new SubscriberChangeEvent[]{delta});
    }

    public void projectDeconfigured(IProject project) {
        try {
            this.getRemoteTree().flushVariants((IResource)project, 2);
        }
        catch (TeamException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        SubscriberChangeEvent delta = new SubscriberChangeEvent((Subscriber)this, 4, (IResource)project);
        this.fireTeamResourceChange((ISubscriberChangeEvent[])new SubscriberChangeEvent[]{delta});
    }

    public void setRemote(IResource resource, IResourceVariant remote, IProgressMonitor monitor) throws TeamException {
        IResource[] changedResources = ((CVSResourceVariantTree)this.getRemoteTree()).collectChanges(resource, remote, 2, monitor);
        if (changedResources.length != 0) {
            this.fireTeamResourceChange((ISubscriberChangeEvent[])SubscriberChangeEvent.asSyncChangedDeltas((Subscriber)this, (IResource[])changedResources));
        }
    }

    protected IResourceVariantTree getBaseTree() {
        return this.baseTree;
    }

    protected IResourceVariantTree getRemoteTree() {
        return this.remoteTree;
    }

    public void collectOutOfSync(IResource[] resources, int depth, final SyncInfoSet set, final IProgressMonitor monitor) {
        monitor.beginTask(null, -1);
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            try {
                if (!this.isSupervised(resource)) {
                    return;
                }
            }
            catch (TeamException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
            }
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource innerResource) throws CoreException {
                        try {
                            SyncInfo info;
                            Policy.checkCanceled(monitor);
                            if (innerResource.getType() != 1) {
                                monitor.subTask(Policy.bind("CVSWorkspaceSubscriber.1", innerResource.getFullPath().toString()));
                            }
                            if (CVSWorkspaceSubscriber.this.isOutOfSync(innerResource, monitor) && (info = CVSWorkspaceSubscriber.this.getSyncInfo(innerResource)) != null && info.getKind() != 0) {
                                set.add(info);
                            }
                        }
                        catch (TeamException e) {
                            set.addError((ITeamStatus)new TeamStatus(4, "org.eclipse.team.cvs.core", 1, Policy.bind("CVSWorkspaceSubscriber.2", innerResource.getFullPath().toString(), e.getMessage()), (Throwable)e, innerResource));
                        }
                        return true;
                    }
                }, depth, true);
                continue;
            }
            catch (CoreException e) {
                set.addError((ITeamStatus)new TeamStatus(4, "org.eclipse.team.cvs.core", 2, e.getMessage(), (Throwable)e, (IResource)ResourcesPlugin.getWorkspace().getRoot()));
            }
        }
        monitor.done();
    }

    boolean isOutOfSync(IResource resource, IProgressMonitor monitor) throws TeamException {
        return this.hasIncomingChange(resource) || this.hasOutgoingChange(resource, monitor);
    }

    private boolean hasIncomingChange(IResource resource) throws TeamException {
        return this.getRemoteByteStore().isVariantKnown(resource);
    }

    private boolean hasOutgoingChange(IResource resource, IProgressMonitor monitor) throws CVSException {
        if (resource.getType() == 4 || resource.getType() == 8) {
            return false;
        }
        int state = EclipseSynchronizer.getInstance().getModificationState((IResource)resource.getParent());
        if (state == 1) {
            return false;
        }
        if (resource.getType() == 1) {
            ICVSFile file = CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
            return file.isModified(monitor);
        }
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource);
        return !folder.isCVSFolder() && !folder.isIgnored();
    }

    private CVSDescendantResourceVariantByteStore getRemoteByteStore() {
        return (CVSDescendantResourceVariantByteStore)((CVSResourceVariantTree)this.getRemoteTree()).getByteStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemote(CVSTeamProvider provider, ICVSFolder folder, IProgressMonitor monitor) throws TeamException {
        try {
            monitor.beginTask(null, 100);
            IResource resource = folder.getIResource();
            if (resource != null) {
                RemoteFolderTree tree = RemoteFolderTreeBuilder.buildBaseTree((CVSRepositoryLocation)provider.getRemoteLocation(), folder, null, Policy.subMonitorFor(monitor, 50));
                this.setRemote(resource, (IResourceVariant)tree, Policy.subMonitorFor(monitor, 50));
            }
        }
        finally {
            monitor.done();
        }
    }
}

