/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

public abstract class CompositeImageDescriptor
extends ImageDescriptor {
    private ImageData imageData;

    protected CompositeImageDescriptor() {
    }

    private static int alloc(RGB[] map, int red, int green, int blue) {
        RGB c;
        int i;
        for (i = 1; i < map.length && (c = map[i]) != null; ++i) {
            if (c.red != red || c.green != green || c.blue != blue) continue;
            return i;
        }
        if (i < map.length - 1) {
            map[i] = new RGB(red, green, blue);
            return i;
        }
        return 0;
    }

    protected abstract void drawCompositeImage(int var1, int var2);

    protected final void drawImage(ImageData src, int ox, int oy) {
        RGB[] out = this.imageData.getRGBs();
        PaletteData palette = src.palette;
        if (palette.isDirect) {
            ImageData mask = src.getTransparencyMask();
            for (int y = 0; y < src.height; ++y) {
                for (int x = 0; x < src.width; ++x) {
                    if (mask.getPixel(x, y) == 0) continue;
                    int xx = x + ox;
                    int yy = y + oy;
                    if (xx < 0 || xx >= this.imageData.width || yy < 0 || yy >= this.imageData.height) continue;
                    int pixel = src.getPixel(x, y);
                    int r = pixel & palette.redMask;
                    r = palette.redShift < 0 ? r >>> -palette.redShift : r << palette.redShift;
                    int g = pixel & palette.greenMask;
                    g = palette.greenShift < 0 ? g >>> -palette.greenShift : g << palette.greenShift;
                    int b = pixel & palette.blueMask;
                    b = palette.blueShift < 0 ? b >>> -palette.blueShift : b << palette.blueShift;
                    pixel = CompositeImageDescriptor.alloc(out, r, g, b);
                    this.imageData.setPixel(xx, yy, pixel);
                }
            }
            return;
        }
        int[] map = new int[256];
        for (int i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        if (src.getTransparencyType() == 2) {
            ImageData mask = src.getTransparencyMask();
            for (int y = 0; y < src.height; ++y) {
                for (int x = 0; x < src.width; ++x) {
                    if (mask.getPixel(x, y) == 0) continue;
                    int xx = x + ox;
                    int yy = y + oy;
                    if (xx < 0 || xx >= this.imageData.width || yy < 0 || yy >= this.imageData.height) continue;
                    int pixel = src.getPixel(x, y);
                    int newPixel = map[pixel];
                    if (newPixel < 0) {
                        RGB c = palette.getRGB(pixel);
                        map[pixel] = newPixel = CompositeImageDescriptor.alloc(out, c.red, c.green, c.blue);
                    }
                    this.imageData.setPixel(xx, yy, newPixel);
                }
            }
            return;
        }
        int maskPixel = src.transparentPixel;
        for (int y = 0; y < src.height; ++y) {
            for (int x = 0; x < src.width; ++x) {
                int pixel = src.getPixel(x, y);
                if (maskPixel >= 0 && pixel == maskPixel) continue;
                int xx = x + ox;
                int yy = y + oy;
                if (xx < 0 || xx >= this.imageData.width || yy < 0 || yy >= this.imageData.height) continue;
                int newPixel = map[pixel];
                if (newPixel < 0) {
                    RGB c = palette.getRGB(pixel);
                    map[pixel] = newPixel = CompositeImageDescriptor.alloc(out, c.red, c.green, c.blue);
                }
                this.imageData.setPixel(xx, yy, newPixel);
            }
        }
    }

    public ImageData getImageData() {
        Point size = this.getSize();
        RGB black = new RGB(0, 0, 0);
        RGB[] rgbs = new RGB[256];
        rgbs[0] = black;
        rgbs[1] = black;
        PaletteData dataPalette = new PaletteData(rgbs);
        this.imageData = new ImageData(size.x, size.y, 8, dataPalette);
        this.imageData.transparentPixel = 0;
        this.drawCompositeImage(size.x, size.y);
        for (int i = 0; i < rgbs.length; ++i) {
            if (rgbs[i] != null) continue;
            rgbs[i] = black;
        }
        return this.imageData;
    }

    protected abstract Point getSize();
}

