/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.hcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

abstract class Differencer {
    public static final int NO_CHANGE = 0;
    public static final int ADDITION = 1;
    public static final int DELETION = 2;
    public static final int CHANGE = 3;
    public static final int CHANGE_TYPE_MASK = 3;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int CONFLICTING = 12;
    public static final int DIRECTION_MASK = 12;
    public static final int PSEUDO_CONFLICT = 16;

    public Object findDifferences(boolean threeWay, IProgressMonitor pm, Object data, Object ancestor, Object left, Object right) {
        List l;
        Node root = new Node();
        int code = this.traverse(threeWay, root, pm, threeWay ? ancestor : null, left, right);
        if (code != 0 && (l = root.fChildren).size() > 0) {
            Node first = (Node)l.get(0);
            return first.visit(this, data, 0);
        }
        return null;
    }

    private int traverse(boolean threeWay, Node parent, IProgressMonitor pm, Object ancestor, Object left, Object right) {
        Object[] ancestorChildren = this.getChildren(ancestor);
        Object[] rightChildren = this.getChildren(right);
        Object[] leftChildren = this.getChildren(left);
        int code = 0;
        Node node = new Node(parent, ancestor, left, right);
        boolean content = true;
        if ((threeWay && ancestorChildren != null || !threeWay) && rightChildren != null && leftChildren != null) {
            int i;
            HashSet<Object> allSet = new HashSet<Object>(20);
            HashMap<Object, Object> ancestorSet = null;
            HashMap<Object, Object> rightSet = null;
            HashMap<Object, Object> leftSet = null;
            if (ancestorChildren != null) {
                ancestorSet = new HashMap<Object, Object>(10);
                for (i = 0; i < ancestorChildren.length; ++i) {
                    Object ancestorChild = ancestorChildren[i];
                    ancestorSet.put(ancestorChild, ancestorChild);
                    allSet.add(ancestorChild);
                }
            }
            if (rightChildren != null) {
                rightSet = new HashMap<Object, Object>(10);
                for (i = 0; i < rightChildren.length; ++i) {
                    Object rightChild = rightChildren[i];
                    rightSet.put(rightChild, rightChild);
                    allSet.add(rightChild);
                }
            }
            if (leftChildren != null) {
                leftSet = new HashMap<Object, Object>(10);
                for (i = 0; i < leftChildren.length; ++i) {
                    Object leftChild = leftChildren[i];
                    leftSet.put(leftChild, leftChild);
                    allSet.add(leftChild);
                }
            }
            Iterator e = allSet.iterator();
            while (e.hasNext()) {
                Object rightChild;
                Object leftChild;
                Object keyChild = e.next();
                content = false;
                if (pm != null && pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                Object ancestorChild = ancestorSet != null ? ancestorSet.get(keyChild) : null;
                int c = this.traverse(threeWay, node, pm, ancestorChild, leftChild = leftSet != null ? leftSet.get(keyChild) : null, rightChild = rightSet != null ? rightSet.get(keyChild) : null);
                if ((c & 3) == 0) continue;
                code |= 3;
                code |= c & 0xC;
            }
        }
        if (content) {
            code = this.compare(threeWay, ancestor, left, right);
        }
        node.fCode = code;
        return code;
    }

    protected abstract Object visit(Object var1, int var2, Object var3, Object var4, Object var5);

    private int compare(boolean threeway, Object ancestor, Object left, Object right) {
        int description = 0;
        if (threeway) {
            if (ancestor == null) {
                if (left == null) {
                    if (right != null) {
                        description = 9;
                    }
                } else if (right == null) {
                    description = 5;
                } else {
                    description = 13;
                    if (this.contentsEqual(left, right)) {
                        description |= 0x10;
                    }
                }
            } else if (left == null) {
                description = right == null ? 30 : (this.contentsEqual(ancestor, right) ? 6 : 15);
            } else if (right == null) {
                description = this.contentsEqual(ancestor, left) ? 10 : 15;
            } else {
                boolean ay = this.contentsEqual(ancestor, left);
                boolean am = this.contentsEqual(ancestor, right);
                if (!ay || !am) {
                    if (ay && !am) {
                        description = 11;
                    } else if (!ay && am) {
                        description = 7;
                    } else {
                        description = 15;
                        if (this.contentsEqual(left, right)) {
                            description |= 0x10;
                        }
                    }
                }
            }
        } else if (left == null) {
            if (right != null) {
                description = 1;
            }
        } else if (right == null) {
            description = 2;
        } else if (!this.contentsEqual(left, right)) {
            description = 3;
        }
        return description;
    }

    protected abstract boolean contentsEqual(Object var1, Object var2);

    protected abstract Object[] getChildren(Object var1);

    static class Node {
        List fChildren;
        int fCode;
        Object fAncestor;
        Object fLeft;
        Object fRight;

        Node() {
        }

        Node(Node parent, Object ancestor, Object left, Object right) {
            parent.add(this);
            this.fAncestor = ancestor;
            this.fLeft = left;
            this.fRight = right;
        }

        void add(Node child) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList();
            }
            this.fChildren.add(child);
        }

        Object visit(Differencer d, Object parent, int level) {
            if (this.fCode == 0) {
                return null;
            }
            Object data = d.visit(parent, this.fCode, this.fAncestor, this.fLeft, this.fRight);
            if (this.fChildren != null) {
                Iterator i = this.fChildren.iterator();
                while (i.hasNext()) {
                    Node n = (Node)i.next();
                    n.visit(d, data, level + 1);
                }
            }
            return data;
        }
    }
}

