/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPVariableElementLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.VariableCreationDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class VariableBlock {
    private ListDialogField fVariablesList;
    private Control fControl;
    private boolean fHasChanges;
    private List fSelectedElements = new ArrayList(0);
    private boolean fAskToBuild;
    private boolean fInPreferencePage;

    public VariableBlock(boolean inPreferencePage, String initSelection) {
        this.fInPreferencePage = inPreferencePage;
        this.fAskToBuild = true;
        String[] buttonLabels = new String[]{NewWizardMessages.getString("VariableBlock.vars.add.button"), NewWizardMessages.getString("VariableBlock.vars.edit.button"), NewWizardMessages.getString("VariableBlock.vars.remove.button")};
        VariablesAdapter adapter = new VariablesAdapter();
        CPVariableElementLabelProvider labelProvider = new CPVariableElementLabelProvider(!inPreferencePage);
        this.fVariablesList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
        this.fVariablesList.setDialogFieldListener(adapter);
        this.fVariablesList.setLabelText(NewWizardMessages.getString("VariableBlock.vars.label"));
        this.fVariablesList.setRemoveButtonIndex(2);
        this.fVariablesList.enableButton(1, false);
        this.fVariablesList.setViewerSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof CPVariableElement && e2 instanceof CPVariableElement) {
                    return ((CPVariableElement)e1).getName().compareTo(((CPVariableElement)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.refresh(initSelection);
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    public void setChanges(boolean hasChanges) {
        this.fHasChanges = hasChanges;
    }

    private String[] getReservedVariableNames() {
        return new String[]{"JRE_LIB", "JRE_SRC", "JRE_SRCROOT"};
    }

    public Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fVariablesList}, true, 0, 0);
        LayoutUtil.setHorizontalGrabbing(this.fVariablesList.getListControl(null));
        this.fControl = composite;
        return composite;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.fVariablesList.getTableViewer().addDoubleClickListener(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fVariablesList.getTableViewer().addSelectionChangedListener(listener);
    }

    private Shell getShell() {
        if (this.fControl != null) {
            return this.fControl.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private boolean containsReserved(List selected) {
        for (int i = selected.size() - 1; i >= 0; --i) {
            if (!((CPVariableElement)selected.get(i)).isReserved()) continue;
            return true;
        }
        return false;
    }

    private static void addAll(Object[] objs, Collection dest) {
        for (int i = 0; i < objs.length; ++i) {
            dest.add(objs[i]);
        }
    }

    private boolean canEdit(List selected, boolean containsReserved) {
        return selected.size() == 1 && !containsReserved;
    }

    private void doSelectionChanged(DialogField field) {
        List selected = this.fVariablesList.getSelectedElements();
        boolean containsReserved = this.containsReserved(selected);
        this.fVariablesList.enableButton(1, this.canEdit(selected, containsReserved));
        this.fVariablesList.enableButton(2, !containsReserved);
        this.fSelectedElements = selected;
    }

    private void editEntries(CPVariableElement entry) {
        List existingEntries = this.fVariablesList.getElements();
        VariableCreationDialog dialog = new VariableCreationDialog(this.getShell(), entry, existingEntries);
        if (dialog.open() != 0) {
            return;
        }
        CPVariableElement newEntry = dialog.getClasspathElement();
        if (entry == null) {
            this.fVariablesList.addElement(newEntry);
            entry = newEntry;
            this.fHasChanges = true;
        } else {
            boolean hasChanges;
            boolean bl = hasChanges = !entry.getName().equals(newEntry.getName()) || !entry.getPath().equals(newEntry.getPath());
            if (hasChanges) {
                this.fHasChanges = true;
                entry.setName(newEntry.getName());
                entry.setPath(newEntry.getPath());
                this.fVariablesList.refresh();
            }
        }
        this.fVariablesList.selectElements((ISelection)new StructuredSelection((Object)entry));
    }

    public List getSelectedElements() {
        return this.fSelectedElements;
    }

    public void performDefaults() {
        this.fVariablesList.removeAllElements();
        String[] reservedName = this.getReservedVariableNames();
        for (int i = 0; i < reservedName.length; ++i) {
            CPVariableElement elem = new CPVariableElement(reservedName[i], (IPath)Path.EMPTY, true);
            elem.setReserved(true);
            this.fVariablesList.addElement(elem);
        }
        this.fHasChanges = true;
    }

    public boolean performOk() {
        ArrayList<String> removedVariables = new ArrayList<String>();
        ArrayList<String> changedVariables = new ArrayList<String>();
        removedVariables.addAll(Arrays.asList(JavaCore.getClasspathVariableNames()));
        List changedElements = this.fVariablesList.getElements();
        for (int i = changedElements.size() - 1; i >= 0; --i) {
            CPVariableElement curr = (CPVariableElement)changedElements.get(i);
            if (curr.isReserved()) {
                changedElements.remove(curr);
            } else {
                IPath path = curr.getPath();
                IPath prevPath = JavaCore.getClasspathVariable((String)curr.getName());
                if (prevPath != null && prevPath.equals(path)) {
                    changedElements.remove(curr);
                } else {
                    changedVariables.add(curr.getName());
                }
            }
            removedVariables.remove(curr.getName());
        }
        int steps = changedElements.size() + removedVariables.size();
        if (steps > 0) {
            boolean needsBuild = false;
            if (this.fAskToBuild && this.doesChangeRequireFullBuild(removedVariables, changedVariables)) {
                String title = NewWizardMessages.getString("VariableBlock.needsbuild.title");
                String message = NewWizardMessages.getString("VariableBlock.needsbuild.message");
                MessageDialog buildDialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = buildDialog.open();
                if (res != 0 && res != 1) {
                    return false;
                }
                needsBuild = res == 0;
            }
            final VariableBlockRunnable runnable = new VariableBlockRunnable(removedVariables, changedElements, needsBuild);
            Job buildJob = new Job(NewWizardMessages.getString("VariableBlock.job.description")){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        runnable.setVariables(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        return iStatus;
                    }
                    catch (OperationCanceledException e) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            buildJob.setUser(true);
            buildJob.schedule();
            return true;
        }
        return true;
    }

    private boolean doesChangeRequireFullBuild(List removed, List changed) {
        try {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] projects = model.getJavaProjects();
            for (int i = 0; i < projects.length; ++i) {
                IClasspathEntry[] entries = projects[i].getRawClasspath();
                for (int k = 0; k < entries.length; ++k) {
                    String var;
                    IClasspathEntry curr = entries[k];
                    if (curr.getEntryKind() != 4 || !removed.contains(var = curr.getPath().segment(0)) && !changed.contains(var)) continue;
                    return true;
                }
            }
        }
        catch (JavaModelException e) {
            return true;
        }
        return false;
    }

    public void setAskToBuild(boolean askToBuild) {
        this.fAskToBuild = askToBuild;
    }

    public void refresh(String initSelection) {
        CPVariableElement initSelectedElement = null;
        Object[] reservedName = this.getReservedVariableNames();
        ArrayList reserved = new ArrayList(reservedName.length);
        VariableBlock.addAll(reservedName, reserved);
        String[] entries = JavaCore.getClasspathVariableNames();
        ArrayList<CPVariableElement> elements = new ArrayList<CPVariableElement>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            String name = entries[i];
            IPath entryPath = JavaCore.getClasspathVariable((String)name);
            if (entryPath != null) {
                CPVariableElement elem = new CPVariableElement(name, entryPath, reserved.contains(name));
                elements.add(elem);
                if (!name.equals(initSelection)) continue;
                initSelectedElement = elem;
                continue;
            }
            JavaPlugin.logErrorMessage("VariableBlock: Classpath variable with null value: " + name);
        }
        this.fVariablesList.setElements(elements);
        if (initSelectedElement != null) {
            StructuredSelection sel = new StructuredSelection(initSelectedElement);
            this.fVariablesList.selectElements((ISelection)sel);
        } else {
            this.fVariablesList.selectFirstElement();
        }
        this.fHasChanges = false;
    }

    private class VariableBlockRunnable
    implements IRunnableWithProgress {
        private List fToRemove;
        private List fToChange;
        private boolean fDoBuild;

        public VariableBlockRunnable(List toRemove, List toChange, boolean doBuild) {
            this.fToRemove = toRemove;
            this.fToChange = toChange;
            this.fDoBuild = doBuild;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(NewWizardMessages.getString("VariableBlock.operation_desc"), this.fDoBuild ? 2 : 1);
            try {
                this.setVariables(monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException();
            }
            finally {
                monitor.done();
            }
        }

        public void setVariables(IProgressMonitor monitor) throws JavaModelException, CoreException {
            int i;
            int nVariables = this.fToChange.size() + this.fToRemove.size();
            String[] names = new String[nVariables];
            IPath[] paths = new IPath[nVariables];
            int k = 0;
            for (i = 0; i < this.fToChange.size(); ++i) {
                CPVariableElement curr = (CPVariableElement)this.fToChange.get(i);
                names[k] = curr.getName();
                paths[k] = curr.getPath();
                ++k;
            }
            for (i = 0; i < this.fToRemove.size(); ++i) {
                names[k] = (String)this.fToRemove.get(i);
                paths[k] = null;
                ++k;
            }
            JavaCore.setClasspathVariables((String[])names, (IPath[])paths, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDoBuild) {
                JavaPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    VariableBlock.this.editEntries(null);
                    break;
                }
                case 1: {
                    List selected = field.getSelectedElements();
                    VariableBlock.this.editEntries((CPVariableElement)selected.get(0));
                }
            }
        }

        public void selectionChanged(ListDialogField field) {
            VariableBlock.this.doSelectionChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            List selected;
            if (VariableBlock.this.fInPreferencePage && VariableBlock.this.canEdit(selected = field.getSelectedElements(), VariableBlock.this.containsReserved(selected))) {
                VariableBlock.this.editEntries((CPVariableElement)selected.get(0));
            }
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }
}

