/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;

public class TraditionalHierarchyViewer
extends TypeHierarchyViewer {
    public TraditionalHierarchyViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle, IWorkbenchPart part) {
        super(parent, (IContentProvider)new TraditionalHierarchyContentProvider(lifeCycle), lifeCycle, part);
    }

    public String getTitle() {
        if (this.isMethodFiltering()) {
            return TypeHierarchyMessages.getString("TraditionalHierarchyViewer.filtered.title");
        }
        return TypeHierarchyMessages.getString("TraditionalHierarchyViewer.title");
    }

    public void updateContent(boolean expand) {
        this.getTree().setRedraw(false);
        this.refresh();
        if (expand) {
            TraditionalHierarchyContentProvider contentProvider = (TraditionalHierarchyContentProvider)this.getContentProvider();
            int expandLevel = contentProvider.getExpandLevel();
            if (this.isMethodFiltering()) {
                ++expandLevel;
            }
            this.expandToLevel(expandLevel);
        }
        this.getTree().setRedraw(true);
    }

    public static class TraditionalHierarchyContentProvider
    extends TypeHierarchyContentProvider {
        public TraditionalHierarchyContentProvider(TypeHierarchyLifeCycle provider) {
            super(provider);
        }

        public int getExpandLevel() {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input != null) {
                    return this.getDepth(hierarchy, input) + 2;
                }
                return 5;
            }
            return 2;
        }

        private int getDepth(ITypeHierarchy hierarchy, IType input) {
            int count = 0;
            IType superType = hierarchy.getSuperclass(input);
            while (superType != null) {
                ++count;
                superType = hierarchy.getSuperclass(superType);
            }
            return count;
        }

        protected final void getRootTypes(List res) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                IType input = hierarchy.getType();
                if (input == null) {
                    IType[] classes = hierarchy.getRootClasses();
                    for (int i = 0; i < classes.length; ++i) {
                        res.add(classes[i]);
                    }
                    IType[] interfaces = hierarchy.getRootInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        res.add(interfaces[i]);
                    }
                } else if (Flags.isInterface((int)hierarchy.getCachedFlags(input))) {
                    res.add(input);
                } else {
                    IType[] roots = hierarchy.getRootClasses();
                    for (int i = 0; i < roots.length; ++i) {
                        if (!this.isObject(roots[i])) continue;
                        res.add(roots[i]);
                        return;
                    }
                    res.addAll(Arrays.asList(roots));
                }
            }
        }

        protected final void getTypesInHierarchy(IType type, List res) {
            block7: {
                ITypeHierarchy hierarchy = this.getHierarchy();
                if (hierarchy == null) break block7;
                IType[] types = hierarchy.getSubtypes(type);
                if (this.isObject(type)) {
                    for (int i = 0; i < types.length; ++i) {
                        IType curr = types[i];
                        if (this.isAnonymous(curr)) continue;
                        res.add(curr);
                    }
                } else {
                    boolean isClass;
                    boolean isHierarchyOnType = hierarchy.getType() != null;
                    boolean bl = isClass = !Flags.isInterface((int)hierarchy.getCachedFlags(type));
                    if (isClass || isHierarchyOnType) {
                        for (int i = 0; i < types.length; ++i) {
                            res.add(types[i]);
                        }
                    } else {
                        for (int i = 0; i < types.length; ++i) {
                            IType curr = types[i];
                            if (!Flags.isInterface((int)hierarchy.getCachedFlags(curr)) && !this.isAnonymous(curr)) continue;
                            res.add(curr);
                        }
                    }
                }
            }
        }

        protected IType getParentType(IType type) {
            ITypeHierarchy hierarchy = this.getHierarchy();
            if (hierarchy != null) {
                return hierarchy.getSuperclass(type);
            }
            return null;
        }
    }
}

