/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.text.CharacterIterator;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentCharacterIterator
implements CharacterIterator,
CharSequence {
    private int fIndex = -1;
    private final IDocument fDocument;
    private final int fFirst;
    private final int fLast;

    private void invariant() {
        Assert.isTrue((this.fIndex >= this.fFirst ? 1 : 0) != 0);
        Assert.isTrue((this.fIndex <= this.fLast ? 1 : 0) != 0);
    }

    public DocumentCharacterIterator(IDocument sequence) {
        this(sequence, 0);
    }

    public DocumentCharacterIterator(IDocument sequence, int first) throws IllegalArgumentException {
        this(sequence, first, sequence.getLength());
    }

    public DocumentCharacterIterator(IDocument sequence, int first, int last) throws IllegalArgumentException {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (first < 0 || first > last) {
            throw new IllegalArgumentException();
        }
        if (last > sequence.getLength()) {
            throw new IllegalArgumentException();
        }
        this.fDocument = sequence;
        this.fFirst = first;
        this.fLast = last;
        this.fIndex = first;
        this.invariant();
    }

    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    public char last() {
        if (this.fFirst == this.fLast) {
            return this.setIndex(this.getEndIndex());
        }
        return this.setIndex(this.getEndIndex() - 1);
    }

    public char current() {
        if (this.fIndex >= this.fFirst && this.fIndex < this.fLast) {
            try {
                return this.fDocument.getChar(this.fIndex);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return '\uffff';
    }

    public char next() {
        return this.setIndex(Math.min(this.fIndex + 1, this.getEndIndex()));
    }

    public char previous() {
        if (this.fIndex > this.getBeginIndex()) {
            return this.setIndex(this.fIndex - 1);
        }
        return '\uffff';
    }

    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.fIndex = position;
        this.invariant();
        return this.current();
    }

    public int getBeginIndex() {
        return this.fFirst;
    }

    public int getEndIndex() {
        return this.fLast;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int length() {
        return this.getEndIndex() - this.getBeginIndex();
    }

    public char charAt(int index) {
        if (index >= this.getBeginIndex() && index <= this.getEndIndex()) {
            try {
                return this.fDocument.getChar(index);
            }
            catch (BadLocationException e) {
                return '\uffff';
            }
        }
        throw new IllegalArgumentException();
    }

    public CharSequence subSequence(int start, int end) {
        return new DocumentCharacterIterator(this.fDocument, this.getBeginIndex() + start, this.getBeginIndex() + start + end);
    }
}

