/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExtractConstantWizard
extends RefactoringWizard {
    private static final String MESSAGE = RefactoringMessages.getString("ExtractConstantInputPage.enter_name");

    public ExtractConstantWizard(ExtractConstantRefactoring ref) {
        super((Refactoring)ref, 36);
        this.setDefaultPageTitle(RefactoringMessages.getString("ExtractConstantWizard.defaultPageTitle"));
    }

    protected void addUserInputPages() {
        String message = null;
        int messageType = 0;
        if (!this.getExtractConstantRefactoring().selectionAllStaticFinal()) {
            message = RefactoringMessages.getString("ExtractConstantInputPage.selection_refers_to_nonfinal_fields");
            messageType = 1;
        } else {
            message = MESSAGE;
            messageType = 0;
        }
        this.addPage((IWizardPage)new ExtractConstantInputPage(message, messageType, this.guessName()));
    }

    private String guessName() {
        try {
            return this.getExtractConstantRefactoring().guessConstantName();
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return "";
        }
    }

    private ExtractConstantRefactoring getExtractConstantRefactoring() {
        return (ExtractConstantRefactoring)this.getRefactoring();
    }

    private static class ExtractConstantInputPage
    extends TextInputWizardPage {
        private Label fLabel;
        private final boolean fInitialValid;
        private final int fOriginalMessageType;
        private final String fOriginalMessage;

        public ExtractConstantInputPage(String description, int messageType, String initialValue) {
            super(description, true, initialValue);
            this.fOriginalMessage = description;
            this.fOriginalMessageType = messageType;
            this.fInitialValid = !"".equals(initialValue);
        }

        public void createControl(Composite parent) {
            Composite result = new Composite(parent, 0);
            this.setControl((Control)result);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 8;
            result.setLayout((Layout)layout);
            RowLayouter layouter = new RowLayouter(2);
            Label label = new Label(result, 0);
            label.setText(RefactoringMessages.getString("ExtractConstantInputPage.constant_name"));
            Text text = this.createTextInputField(result);
            text.selectAll();
            text.setLayoutData((Object)new GridData(768));
            layouter.perform((Control)label, (Control)text, 1);
            this.addAccessModifierGroup(result, layouter);
            this.addReplaceAllCheckbox(result, layouter);
            this.addQualifyReferencesCheckbox(result, layouter);
            this.addSeparator(result, layouter);
            this.addLabel(result, layouter);
            this.validateTextField(text.getText());
            Dialog.applyDialogFont((Control)result);
            WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.jdt.ui.extract_constant_page_context");
        }

        private void addAccessModifierGroup(Composite result, RowLayouter layouter) {
            Label label = new Label(result, 0);
            label.setText(RefactoringMessages.getString("ExtractConstantInputPage.access_modifiers"));
            Composite group = new Composite(result, 0);
            group.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            String[] labels = new String[]{RefactoringMessages.getString("ExtractMethodInputPage.public"), RefactoringMessages.getString("ExtractMethodInputPage.protected"), RefactoringMessages.getString("ExtractMethodInputPage.default"), RefactoringMessages.getString("ExtractMethodInputPage.private")};
            String[] data = new String[]{"public", "protected", "", "private"};
            String visibility = this.getExtractConstantRefactoring().getAccessModifier();
            for (int i = 0; i < labels.length; ++i) {
                Button radio = new Button(group, 16);
                radio.setText(labels[i]);
                radio.setData((Object)data[i]);
                if (data[i] == visibility) {
                    radio.setSelection(true);
                }
                radio.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ ExtractConstantInputPage this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        ExtractConstantInputPage.access$000(this.this$0, (String)event.widget.getData());
                    }
                });
            }
            layouter.perform((Control)label, (Control)group, 1);
        }

        private void addReplaceAllCheckbox(Composite result, RowLayouter layouter) {
            String title = RefactoringMessages.getString("ExtractConstantInputPage.replace_all");
            boolean defaultValue = this.getExtractConstantRefactoring().replaceAllOccurrences();
            Button checkBox = ExtractConstantInputPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractConstantRefactoring().setReplaceAllOccurrences(checkBox.getSelection());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, checkBox){
                private final /* synthetic */ Button val$checkBox;
                private final /* synthetic */ ExtractConstantInputPage this$0;
                {
                    this.this$0 = this$0;
                    this.val$checkBox = val$checkBox;
                }

                public void widgetSelected(SelectionEvent e) {
                    ExtractConstantInputPage.access$100(this.this$0).setReplaceAllOccurrences(this.val$checkBox.getSelection());
                }
            });
        }

        private void addQualifyReferencesCheckbox(Composite result, RowLayouter layouter) {
            String title = RefactoringMessages.getString("ExtractConstantInputPage.qualify_constant_references_with_class_name");
            boolean defaultValue = this.getExtractConstantRefactoring().qualifyReferencesWithDeclaringClassName();
            Button checkBox = ExtractConstantInputPage.createCheckbox(result, title, defaultValue, layouter);
            this.getExtractConstantRefactoring().setQualifyReferencesWithDeclaringClassName(checkBox.getSelection());
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(this, checkBox){
                private final /* synthetic */ Button val$checkBox;
                private final /* synthetic */ ExtractConstantInputPage this$0;
                {
                    this.this$0 = this$0;
                    this.val$checkBox = val$checkBox;
                }

                public void widgetSelected(SelectionEvent e) {
                    ExtractConstantInputPage.access$100(this.this$0).setQualifyReferencesWithDeclaringClassName(this.val$checkBox.getSelection());
                }
            });
        }

        private void addLabel(Composite result, RowLayouter layouter) {
            this.fLabel = new Label(result, 64);
            GridData gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(50);
            this.fLabel.setLayoutData((Object)gd);
            this.updatePreviewLabel();
            layouter.perform((Control)this.fLabel);
        }

        private void addSeparator(Composite result, RowLayouter layouter) {
            Label separator = new Label(result, 258);
            separator.setLayoutData((Object)new GridData(768));
            layouter.perform((Control)separator);
        }

        private void updatePreviewLabel() {
            try {
                if (this.fLabel != null) {
                    this.fLabel.setText(RefactoringMessages.getString("ExtractConstantInputPage.signature_preview") + this.getExtractConstantRefactoring().getConstantSignaturePreview());
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.getString("ExtractTempInputPage.extract_local"), RefactoringMessages.getString("ExtractConstantInputPage.exception"));
            }
        }

        protected RefactoringStatus validateTextField(String text) {
            try {
                this.getExtractConstantRefactoring().setConstantName(text);
                this.updatePreviewLabel();
                RefactoringStatus result = this.getExtractConstantRefactoring().checkConstantNameOnChange();
                if (this.fOriginalMessageType == 1 && result.getSeverity() == 0) {
                    return RefactoringStatus.createInfoStatus((String)this.fOriginalMessage);
                }
                return result;
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.getString("ExtractConstantInputPage.Internal_Error"));
            }
        }

        private void setAccessModifier(String accessModifier) {
            this.getExtractConstantRefactoring().setAccessModifier(accessModifier);
            this.updatePreviewLabel();
        }

        private ExtractConstantRefactoring getExtractConstantRefactoring() {
            return (ExtractConstantRefactoring)this.getRefactoring();
        }

        private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
            Button checkBox = new Button(parent, 32);
            checkBox.setText(title);
            checkBox.setSelection(value);
            layouter.perform((Control)checkBox);
            return checkBox;
        }

        protected boolean isInitialInputValid() {
            return this.fInitialValid;
        }

        protected void restoreMessage() {
            this.setMessage(this.fOriginalMessage, this.fOriginalMessageType);
        }

        static /* synthetic */ void access$000(ExtractConstantInputPage x0, String x1) {
            x0.setAccessModifier(x1);
        }

        static /* synthetic */ ExtractConstantRefactoring access$100(ExtractConstantInputPage x0) {
            return x0.getExtractConstantRefactoring();
        }
    }
}

