/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.internal.core.ConfigurationPolicy;
import org.eclipse.update.internal.core.ConfiguredSite;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.SiteLocal;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteReconciler
extends ModelObject {
    public SiteReconciler(SiteLocal siteLocal) {
    }

    URL resolveSiteEntry(IPlatformConfiguration.ISiteEntry newSiteEntry) throws CoreException {
        URL resolvedURL = null;
        try {
            resolvedURL = Platform.resolve((URL)newSiteEntry.getURL());
        }
        catch (IOException e) {
            throw Utilities.newCoreException(Policy.bind("SiteLocal.UnableToResolve", newSiteEntry.getURL().toExternalForm()), e);
        }
        return resolvedURL;
    }

    public static void checkConfiguredFeaturesOld(IConfiguredSite configuredSite) throws CoreException {
        ConfiguredSite cSite = (ConfiguredSite)configuredSite;
        IFeatureReference[] configuredFeatures = cSite.getConfiguredFeatures();
        ConfigurationPolicy cPolicy = cSite.getConfigurationPolicy();
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Compare features within :" + configuredSite.getSite().getURL());
        }
        for (int indexConfiguredFeatures = 0; indexConfiguredFeatures < configuredFeatures.length - 1; ++indexConfiguredFeatures) {
            IFeatureReference featureToCompare = configuredFeatures[indexConfiguredFeatures];
            for (int restOfConfiguredFeatures = indexConfiguredFeatures + 1; restOfConfiguredFeatures < configuredFeatures.length; ++restOfConfiguredFeatures) {
                int result = SiteReconciler.compare(featureToCompare, configuredFeatures[restOfConfiguredFeatures]);
                if (result == 0) continue;
                if (result == 1) {
                    cPolicy.unconfigure(configuredFeatures[restOfConfiguredFeatures], true, false);
                }
                if (result != 2) continue;
                cPolicy.unconfigure(featureToCompare, true, false);
            }
        }
    }

    private static int compare(IFeatureReference featureRef1, IFeatureReference featureRef2) throws CoreException {
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Compare: " + featureRef1 + " && " + featureRef2);
        }
        if (featureRef1 == null) {
            return 0;
        }
        IFeature feature1 = null;
        IFeature feature2 = null;
        try {
            feature1 = featureRef1.getFeature(null);
            feature2 = featureRef2.getFeature(null);
        }
        catch (CoreException e) {
            UpdateCore.warn(null, e);
            return 0;
        }
        if (feature1 == null || feature2 == null) {
            return 0;
        }
        VersionedIdentifier id1 = feature1.getVersionedIdentifier();
        VersionedIdentifier id2 = feature2.getVersionedIdentifier();
        if (id1 == null || id2 == null) {
            return 0;
        }
        if (id1.getIdentifier() != null && id1.getIdentifier().equals(id2.getIdentifier())) {
            PluginVersionIdentifier version1 = id1.getVersion();
            PluginVersionIdentifier version2 = id2.getVersion();
            if (version1 != null) {
                if (version1.isGreaterThan(version2)) {
                    return 1;
                }
                return 2;
            }
            return 2;
        }
        return 0;
    }

    public static void checkConfiguredFeatures(IConfiguredSite configuredSite) {
        Map patches;
        ConfiguredSite cSite = (ConfiguredSite)configuredSite;
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Validate configuration of site " + cSite.getSite().getURL());
        }
        IFeatureReference[] configuredRefs = cSite.getConfiguredFeatures();
        ArrayList<IFeature> allPossibleConfiguredFeatures = new ArrayList<IFeature>();
        for (int i = 0; i < configuredRefs.length; ++i) {
            try {
                IFeature feature = configuredRefs[i].getFeature(null);
                allPossibleConfiguredFeatures.add(feature);
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) continue;
                UpdateCore.debug("   configured feature " + feature.getVersionedIdentifier().toString());
                continue;
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
        }
        ArrayList topFeatures = SiteReconciler.computeTopFeatures(allPossibleConfiguredFeatures);
        ArrayList topNonEfixFeatures = SiteReconciler.getNonEfixFeatures(topFeatures);
        ArrayList configuredFeatures = SiteReconciler.expandFeatures(topNonEfixFeatures, configuredSite);
        if (topFeatures.size() != topNonEfixFeatures.size() && !(patches = SiteReconciler.getPatchesAsFeature(allPossibleConfiguredFeatures)).isEmpty()) {
            List efixesToEnable = SiteReconciler.getPatchesToEnable(patches, configuredFeatures);
            Iterator iter = efixesToEnable.iterator();
            while (iter.hasNext()) {
                IFeature element = (IFeature)iter.next();
                ArrayList expandedEfix = new ArrayList();
                SiteReconciler.expandEfixFeature(element, expandedEfix, configuredSite);
                configuredFeatures.addAll(expandedEfix);
            }
        }
        ArrayList extras = SiteReconciler.diff(allPossibleConfiguredFeatures, configuredFeatures);
        ConfigurationPolicy cPolicy = cSite.getConfigurationPolicy();
        for (int i = 0; i < extras.size(); ++i) {
            IFeature feature = (IFeature)extras.get(i);
            ISiteFeatureReference ref = cSite.getSite().getFeatureReference(feature);
            try {
                cPolicy.unconfigure(ref, true, false);
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) continue;
                UpdateCore.debug("Unconfiguring \"extra\" feature " + feature.getVersionedIdentifier().toString());
                continue;
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
        }
    }

    private static ArrayList computeTopFeatures(ArrayList features) {
        HashMap<VersionedIdentifier, IFeature> topFeatures = new HashMap<VersionedIdentifier, IFeature>(features.size());
        Iterator it = features.iterator();
        while (it.hasNext()) {
            IFeature f = (IFeature)it.next();
            topFeatures.put(f.getVersionedIdentifier(), f);
        }
        it = features.iterator();
        while (it.hasNext()) {
            try {
                IIncludedFeatureReference[] children = ((IFeature)it.next()).getIncludedFeatureReferences();
                for (int j = 0; j < children.length; ++j) {
                    try {
                        topFeatures.remove(children[j].getVersionedIdentifier());
                        continue;
                    }
                    catch (CoreException e1) {
                        if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_WARNINGS) continue;
                        UpdateCore.warn("", e1);
                    }
                }
            }
            catch (CoreException e) {
                UpdateCore.warn("", e);
            }
        }
        ArrayList list = new ArrayList();
        list.addAll(topFeatures.values());
        if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
            UpdateCore.debug("Computed top-level features");
            for (int i = 0; i < topFeatures.size(); ++i) {
                UpdateCore.debug("   " + ((IFeature)list.get(i)).getVersionedIdentifier().toString());
            }
        }
        return list;
    }

    private static ArrayList expandFeatures(ArrayList features, IConfiguredSite configuredSite) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < features.size(); ++i) {
            SiteReconciler.expandFeature((IFeature)features.get(i), result, configuredSite);
        }
        return result;
    }

    private static void expandFeature(IFeature feature, ArrayList features, IConfiguredSite configuredSite) {
        if (!features.contains(feature)) {
            features.add(feature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + feature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] children = null;
        try {
            children = feature.getIncludedFeatureReferences();
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
            return;
        }
        for (int j = 0; j < children.length; ++j) {
            IFeature child;
            block7: {
                child = null;
                try {
                    child = children[j].getFeature(null);
                }
                catch (CoreException e) {
                    if (UpdateManagerUtils.isOptional(children[j])) break block7;
                    UpdateCore.warn("", e);
                }
            }
            if (child == null) continue;
            SiteReconciler.expandFeature(child, features, configuredSite);
        }
    }

    private static ArrayList diff(ArrayList left, ArrayList right) {
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        for (int i = 0; i < left.size(); ++i) {
            IFeature feature = (IFeature)left.get(i);
            if (right.contains(feature)) continue;
            result.add(feature);
        }
        return result;
    }

    private static Map getPatchesAsFeature(ArrayList allConfiguredFeatures) {
        HashMap patches = new HashMap();
        if (allConfiguredFeatures != null) {
            Iterator iter = allConfiguredFeatures.iterator();
            while (iter.hasNext()) {
                ArrayList<VersionedIdentifier> patchedFeaturesID = new ArrayList<VersionedIdentifier>();
                IFeature element = (IFeature)iter.next();
                for (int i = 0; i < element.getImports().length; ++i) {
                    if (!element.getImports()[i].isPatch()) continue;
                    VersionedIdentifier id = element.getImports()[i].getVersionedIdentifier();
                    if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                        UpdateCore.debug("Found patch " + element + " for feature identifier " + id);
                    }
                    patchedFeaturesID.add(id);
                }
                if (patchedFeaturesID.isEmpty()) continue;
                patches.put(element, patchedFeaturesID);
            }
        }
        return patches;
    }

    private static List getPatchesToEnable(Map efixes, ArrayList configuredFeatures) {
        ArrayList<VersionedIdentifier> enabledVersionedIdentifier = new ArrayList<VersionedIdentifier>();
        Iterator<Object> iter = configuredFeatures.iterator();
        while (iter.hasNext()) {
            IFeature element = (IFeature)iter.next();
            enabledVersionedIdentifier.add(element.getVersionedIdentifier());
        }
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        iter = efixes.keySet().iterator();
        while (iter.hasNext()) {
            boolean toEnable = false;
            IFeature efixFeature = (IFeature)iter.next();
            List patchedFeatures = (List)efixes.get(efixFeature);
            Iterator patchedFeaturesIter = patchedFeatures.iterator();
            while (patchedFeaturesIter.hasNext() && !toEnable) {
                VersionedIdentifier patchedFeatureID = (VersionedIdentifier)patchedFeaturesIter.next();
                if (!enabledVersionedIdentifier.contains(patchedFeatureID)) continue;
                toEnable = true;
            }
            if (!toEnable) {
                if (!UpdateCore.DEBUG || !UpdateCore.DEBUG_SHOW_RECONCILER) continue;
                UpdateCore.debug("The Patch " + efixFeature + " does not patch any enabled features: it will be disabled");
                continue;
            }
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("The patch " + efixFeature + " will be enabled.");
            }
            result.add(efixFeature);
        }
        return result;
    }

    private static ArrayList getNonEfixFeatures(ArrayList topFeatures) {
        Map efixFeatures = SiteReconciler.getPatchesAsFeature(topFeatures);
        Set keySet = efixFeatures.keySet();
        if (keySet == null || keySet.isEmpty()) {
            return topFeatures;
        }
        Iterator iter = topFeatures.iterator();
        ArrayList<IFeature> result = new ArrayList<IFeature>();
        while (iter.hasNext()) {
            IFeature element = (IFeature)iter.next();
            if (keySet.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    private static void expandEfixFeature(IFeature feature, ArrayList features, IConfiguredSite configuredSite) {
        if (!features.contains(feature)) {
            features.add(feature);
            if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_RECONCILER) {
                UpdateCore.debug("Retaining configured feature " + feature.getVersionedIdentifier().toString());
            }
        }
        IIncludedFeatureReference[] children = null;
        try {
            children = feature.getIncludedFeatureReferences();
        }
        catch (CoreException e) {
            UpdateCore.warn("", e);
            return;
        }
        for (int j = 0; j < children.length; ++j) {
            IFeature child;
            block7: {
                child = null;
                try {
                    child = children[j].getFeature(null);
                }
                catch (CoreException e) {
                    if (children[j].isOptional()) break block7;
                    UpdateCore.warn("", e);
                }
            }
            if (child == null || UpdateCore.isPatch(child)) continue;
            SiteReconciler.expandEfixFeature(child, features, configuredSite);
        }
    }
}

