/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IInstallHandler;
import org.eclipse.update.core.IInstallHandlerEntry;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.InstallMonitor;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Policy;
import org.eclipse.update.internal.core.UpdateCore;

public class InstallHandlerProxy
implements IInstallHandler {
    private IFeature feature = null;
    private int type;
    private IInstallHandler handler = null;
    private IStatus savedStatus = null;
    private boolean DEBUG = false;
    private static final String EXT_PLUGIN = "org.eclipse.update.core";
    private static final String EXT_POINT = "installHandlers";

    private InstallHandlerProxy() {
    }

    public InstallHandlerProxy(int type, IFeature feature, IInstallHandlerEntry entry, InstallMonitor monitor) throws CoreException {
        this.initialize(type, feature, entry, monitor);
    }

    public void initialize(int type, IFeature feature, IInstallHandlerEntry entry, InstallMonitor monitor) throws CoreException {
        this.DEBUG = UpdateCore.DEBUG_SHOW_IHANDLER;
        if (feature == null) {
            throw new IllegalArgumentException();
        }
        this.feature = feature;
        this.type = type;
        if (entry == null) {
            if (this.DEBUG) {
                this.debug("not specified");
            }
            return;
        }
        String library = entry.getLibrary();
        String handlerName = entry.getHandlerName();
        if (handlerName == null || handlerName.trim().equals("")) {
            if (this.DEBUG) {
                this.debug("not specified");
            }
            return;
        }
        if (this.DEBUG) {
            this.debug("handler=" + handlerName);
            this.debug("path=   " + library);
        }
        try {
            this.handler = library == null || library.trim().equals("") ? this.getGlobalHandler(handlerName) : this.getLocalHandler(library, handlerName);
            if (this.handler == null) {
                return;
            }
            this.handler.initialize(type, feature, entry, monitor);
        }
        catch (ClassNotFoundException e) {
            this.handleExceptionInInit(Policy.bind("InstallHandler.notFound", feature.getLabel()), e);
        }
        catch (ClassCastException e) {
            this.handleExceptionInInit(Policy.bind("InstallHandler.invalidHandler", feature.getLabel()), e);
        }
        catch (CoreException e) {
            this.handleExceptionInInit(null, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.handleExceptionInInit(Policy.bind("InstallHandler.unableToCreateHandler", feature.getLabel()), e);
        }
    }

    public void installInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling installInitiated()");
            }
            this.handler.installInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void pluginsDownloaded(IPluginEntry[] plugins) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling pluginsDownloaded()");
            }
            this.handler.pluginsDownloaded(plugins);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeInstall()");
            }
            this.handler.completeInstall(consumer);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void nonPluginDataDownloaded(INonPluginEntry[] nonPluginData, IVerificationListener listener) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling nonPluginDataDownloaded()");
            }
            this.handler.nonPluginDataDownloaded(nonPluginData, listener);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void installCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling installCompleted()");
            }
            this.handler.installCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void configureInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling configureInitiated()");
            }
            this.handler.configureInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeConfigure() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeConfigure()");
            }
            this.handler.completeConfigure();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void configureCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling configureCompleted()");
            }
            this.handler.configureCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void unconfigureInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling unconfigureInitiated()");
            }
            this.handler.unconfigureInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeUnconfigure() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeUnconfigure()");
            }
            this.handler.completeUnconfigure();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void unconfigureCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            if (this.savedStatus == null) {
                return;
            }
            throw new CoreException(this.savedStatus);
        }
        try {
            if (this.DEBUG) {
                this.debug("calling unconfigureCompleted()");
            }
            this.handler.unconfigureCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
        if (this.savedStatus != null) {
            throw new CoreException(this.savedStatus);
        }
    }

    public void uninstallInitiated() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling uninstallInitiated()");
            }
            this.handler.uninstallInitiated();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void completeUninstall() throws CoreException {
        if (this.handler == null) {
            return;
        }
        try {
            if (this.DEBUG) {
                this.debug("calling completeUninstall()");
            }
            this.handler.completeUninstall();
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
    }

    public void uninstallCompleted(boolean success) throws CoreException {
        if (this.handler == null) {
            if (this.savedStatus == null) {
                return;
            }
            throw new CoreException(this.savedStatus);
        }
        try {
            if (this.DEBUG) {
                this.debug("calling uninstallCompleted()");
            }
            this.handler.uninstallCompleted(success);
        }
        catch (Throwable e) {
            this.handleExceptionInCall(e, this.feature);
        }
        if (this.savedStatus != null) {
            throw new CoreException(this.savedStatus);
        }
    }

    private void handleExceptionInInit(String s, Exception e) throws CoreException {
        CoreException ce = e instanceof CoreException ? (CoreException)((Object)e) : Utilities.newCoreException(s, e);
        if (!this.isUndoAction()) {
            throw ce;
        }
        String id = UpdateCore.getPlugin().getBundle().getSymbolicName();
        Status status = new Status(4, id, 0, "InstallHandler.deactivated", (Throwable)ce);
        UpdateCore.getPlugin().getLog().log((IStatus)status);
        this.handler = null;
        this.savedStatus = status;
    }

    private void handleExceptionInCall(Throwable e, IFeature feature) throws CoreException {
        CoreException ce = e instanceof CoreException ? (CoreException)e : Utilities.newCoreException(Policy.bind("InstallHandler.callException", feature.getLabel()), e);
        if (!this.isUndoAction()) {
            throw ce;
        }
        String id = UpdateCore.getPlugin().getBundle().getSymbolicName();
        Status status = new Status(4, id, 0, "InstallHandler.deactivated", (Throwable)ce);
        UpdateCore.getPlugin().getLog().log((IStatus)status);
        this.handler = null;
        this.savedStatus = status;
    }

    private boolean isUndoAction() {
        return this.type != 1 && this.type != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IInstallHandler getLocalHandler(String lib, String name) throws Exception {
        URL cp;
        block14: {
            Exception e22;
            InputStream is;
            File tempLib;
            block13: {
                ContentReference baseRef = this.feature.getFeatureContentProvider().getFeatureManifestReference(null);
                URL base = null;
                if (baseRef != null) {
                    base = baseRef.asURL();
                }
                if (base == null) {
                    throw Utilities.newCoreException(Policy.bind("InstallHandler.unableToCreateHandler", this.feature.getLabel()), null);
                }
                cp = new URL(base, lib);
                if (this.type != 4) break block14;
                tempLib = File.createTempFile("tmp", ".jar");
                tempLib.deleteOnExit();
                FileOutputStream fos = null;
                is = null;
                try {
                    fos = new FileOutputStream(tempLib);
                    is = UpdateCore.getPlugin().get(cp).getInputStream();
                    Utilities.copy(is, fos, null);
                    Object var10_9 = null;
                    if (fos == null) break block13;
                }
                catch (Throwable throwable) {
                    Exception e22;
                    Object var10_10 = null;
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e22) {
                            // empty catch block
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e22) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    fos.close();
                }
                catch (Exception e22) {
                    // empty catch block
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e22) {}
            }
            cp = tempLib.toURL();
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{cp}, this.getClass().getClassLoader());
        Class<?> clazz = loader.loadClass(name);
        IInstallHandler handler = (IInstallHandler)clazz.newInstance();
        return handler;
    }

    private IInstallHandler getGlobalHandler(String name) throws Exception {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] handlerExtension = reg.getConfigurationElementsFor(EXT_PLUGIN, EXT_POINT, name);
        if (handlerExtension == null || handlerExtension.length <= 0) {
            throw Utilities.newCoreException(Policy.bind("InstallHandler.unableToCreateHandler", this.feature.getLabel()), null);
        }
        return (IInstallHandler)handlerExtension[0].createExecutableExtension("class");
    }

    private void debug(String s) {
        String pfx = this.feature == null ? "" : this.feature.getVersionedIdentifier().toString();
        System.out.println("InstallHandler[" + pfx + "]: " + s);
    }
}

