/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.eclipse.ui.internal.dialogs.PropertyPageNode;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RegistryPageContributor
implements IPropertyPageContributor {
    private String pluginId;
    private String pageName;
    private String iconName;
    private String pageId;
    private boolean isResourceContributor = false;
    private IConfigurationElement pageElement;
    private HashMap filterProperties;
    private static String[] resourceClassNames = new String[]{"org.eclipse.core.resources.IResource", "org.eclipse.core.resources.IContainer", "org.eclipse.core.resources.IFolder", "org.eclipse.core.resources.IProject", "org.eclipse.core.resources.IFile"};
    static /* synthetic */ Class class$org$eclipse$core$runtime$IAdaptable;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;
    static /* synthetic */ Class class$org$eclipse$ui$IActionFilter;

    public RegistryPageContributor(String pluginId, String pageId, String pageName, String iconName, HashMap filterProperties, String objectClassName, boolean adaptable, IConfigurationElement pageElement) {
        this.pluginId = pluginId;
        this.pageId = pageId;
        this.pageName = pageName;
        this.iconName = iconName;
        this.filterProperties = filterProperties;
        this.pageElement = pageElement;
        if (adaptable) {
            this.checkIsResourcePage(objectClassName);
        }
    }

    public boolean contributePropertyPages(PropertyPageManager mng, IAdaptable element) {
        PropertyPageNode node = new PropertyPageNode(this, element);
        mng.addToRoot((IPreferenceNode)node);
        return true;
    }

    public IWorkbenchPropertyPage createPage(IAdaptable element) throws CoreException {
        IWorkbenchPropertyPage ppage = null;
        ppage = (IWorkbenchPropertyPage)WorkbenchPlugin.createExtension(this.pageElement, "class");
        ppage.setTitle(this.pageName);
        if (this.isResourceContributor) {
            Object resourceAdapter;
            IAdaptable resource;
            Class resourceClass = LegacyResourceSupport.getResourceClass();
            IAdaptable iAdaptable = resource = resourceClass != null ? (IAdaptable)element.getAdapter(resourceClass) : null;
            if (resource == null && (resourceClass = LegacyResourceSupport.getIContributorResourceAdapterClass()) != null && (resourceAdapter = element.getAdapter(resourceClass)) != null) {
                try {
                    Method m = resourceClass.getMethod("getAdaptedResource", class$org$eclipse$core$runtime$IAdaptable == null ? (class$org$eclipse$core$runtime$IAdaptable = RegistryPageContributor.class$("org.eclipse.core.runtime.IAdaptable")) : class$org$eclipse$core$runtime$IAdaptable);
                    resource = (IAdaptable)m.invoke(resourceAdapter, element);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (resource != null) {
                ppage.setElement(resource);
            }
        }
        if (ppage.getElement() == null) {
            ppage.setElement(element);
        }
        return ppage;
    }

    public ImageDescriptor getPageIcon() {
        if (this.iconName == null) {
            return null;
        }
        IExtension extension = this.pageElement.getDeclaringExtension();
        return AbstractUIPlugin.imageDescriptorFromPlugin(extension.getNamespace(), this.iconName);
    }

    public String getPageId() {
        return this.pageId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean isApplicableTo(Object object) {
        Object result;
        String nameFilter = this.pageElement.getAttribute("nameFilter");
        if (nameFilter != null) {
            String elementName;
            IWorkbenchAdapter adapter;
            String objectName = object.toString();
            if (object instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = RegistryPageContributor.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null && (elementName = adapter.getLabel(object)) != null) {
                objectName = elementName;
            }
            if (!SelectionEnabler.verifyNameMatch(objectName, nameFilter)) {
                return false;
            }
        }
        if (this.filterProperties == null) {
            return true;
        }
        IActionFilter filter = null;
        Object testObject = object;
        Class resourceClass = LegacyResourceSupport.getResourceClass();
        if (this.isResourceContributor && resourceClass != null && !resourceClass.isInstance(object) && object instanceof IAdaptable && (result = ((IAdaptable)object).getAdapter(resourceClass)) != null) {
            testObject = result;
        }
        if (testObject instanceof IActionFilter) {
            filter = (IActionFilter)testObject;
        } else if (testObject instanceof IAdaptable) {
            filter = (IActionFilter)((IAdaptable)testObject).getAdapter(class$org$eclipse$ui$IActionFilter == null ? (class$org$eclipse$ui$IActionFilter = RegistryPageContributor.class$("org.eclipse.ui.IActionFilter")) : class$org$eclipse$ui$IActionFilter);
        }
        if (filter != null) {
            return this.testCustom(testObject, filter);
        }
        return true;
    }

    private boolean testCustom(Object object, IActionFilter filter) {
        if (this.filterProperties == null) {
            return false;
        }
        Iterator iter = this.filterProperties.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (filter.testAttribute(object, key, value = (String)this.filterProperties.get(key))) continue;
            return false;
        }
        return true;
    }

    private void checkIsResourcePage(String objectClassName) {
        for (int i = 0; i < resourceClassNames.length; ++i) {
            if (!resourceClassNames[i].equals(objectClassName)) continue;
            this.isResourceContributor = true;
            return;
        }
    }

    public boolean canAdapt() {
        return this.isResourceContributor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

