/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblem
implements ProblemSeverities,
IProblem {
    private static final String LINE_DELIMITER = System.getProperty("line.separator");
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    private int severity;
    private String[] arguments;
    private String message;

    public DefaultProblem(char[] originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line) {
        this.fileName = originatingFileName;
        this.message = message;
        this.id = id;
        this.arguments = stringArguments;
        this.severity = severity;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.line = line;
    }

    public String errorReportSource(char[] unitSource) {
        int i;
        int end;
        char c;
        int begin;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0) {
            return Util.bind("problem.noSourceInformation");
        }
        StringBuffer errorBuffer = new StringBuffer(" ");
        errorBuffer.append(Util.bind("problem.atLine", String.valueOf(this.line)));
        errorBuffer.append(LINE_DELIMITER).append("\t");
        int SPACE = 32;
        int MARK = 94;
        int TAB = 9;
        int length = unitSource.length;
        int n = begin = this.startPosition >= length ? length - 1 : this.startPosition;
        while (begin > 0 && (c = unitSource[begin - 1]) != '\n' && c != '\r') {
            --begin;
        }
        int n2 = end = this.endPosition >= length ? length - 1 : this.endPosition;
        while (end + 1 < length && (c = unitSource[end + 1]) != '\r' && c != '\n') {
            ++end;
        }
        while ((c = unitSource[begin]) == ' ' || c == '\t') {
            ++begin;
        }
        errorBuffer.append(unitSource, begin, end - begin + 1);
        errorBuffer.append(LINE_DELIMITER).append("\t");
        for (i = begin; i < this.startPosition; ++i) {
            errorBuffer.append(unitSource[i] == '\t' ? (char)'\t' : ' ');
        }
        for (i = this.startPosition; i <= (this.endPosition >= length ? length - 1 : this.endPosition); ++i) {
            errorBuffer.append('^');
        }
        return errorBuffer.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setOriginatingFileName(char[] fileName) {
        this.fileName = fileName;
    }

    public void setSourceEnd(int sourceEnd) {
        this.endPosition = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.line = lineNumber;
    }

    public void setSourceStart(int sourceStart) {
        this.startPosition = sourceStart;
    }

    public String toString() {
        String s = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            s = s + this.message;
        } else if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                s = s + " " + this.arguments[i];
            }
        }
        return s;
    }
}

