/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogSession;
import org.eclipse.pde.internal.runtime.logview.LogView;
import org.eclipse.pde.internal.runtime.logview.LogViewLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EventDetailsDialog
extends Dialog {
    private LogEntry entry;
    private LogEntry parentEntry;
    private LogViewLabelProvider labelProvider = new LogViewLabelProvider();
    private static int COPY_ID = 22;
    private TableTreeViewer provider;
    private int elementNum;
    private int totalElementCount;
    private LogEntry[] entryChildren;
    private int childIndex = 0;
    private boolean isOpen;
    private Label dateLabel;
    private Label severityImageLabel;
    private Label severityLabel;
    private Text msgText;
    private Text stackTraceText;
    private Text sessionDataText;
    private Clipboard clipboard;
    private Button copyButton;
    private Button backButton;
    private Button nextButton;
    private Image imgNextEnabled;
    private Image imgPrevEnabled;
    private Image imgCopyEnabled;
    private SashForm sashForm;
    private static int ASCENDING = 1;
    private Comparator comparator = null;
    private Collator collator;
    private IDialogSettings dialogSettings;
    private Point dialogLocation;
    private Point dialogSize;
    private int[] sashWeights;
    private String EVENT_NO_STACK = "EventDetailsDialog.noStack";
    private String EVENT_PREVIOUS = "EventDetailsDialog.previous";
    private String EVENT_NEXT = "EventDetailsDialog.next";
    private String EVENT_COPY = "EventDetailsDialog.copy";

    protected EventDetailsDialog(Shell parentShell, IAdaptable selection, ISelectionProvider provider) {
        super(parentShell);
        this.provider = (TableTreeViewer)provider;
        this.entry = (LogEntry)selection;
        this.setShellStyle(3312);
        this.clipboard = new Clipboard(parentShell.getDisplay());
        this.initialize();
        this.createImages();
        this.collator = Collator.getInstance();
        this.readConfiguration();
    }

    private void initialize() {
        this.elementNum = this.getParentElementNum();
        this.totalElementCount = this.provider.getTableTree().getTable().getItemCount() - this.getVisibleChildrenCount();
        this.parentEntry = (LogEntry)((Object)this.entry.getParent((Object)this.entry));
        if (this.isChild(this.entry)) {
            this.setEntryChildren(this.parentEntry);
            this.resetChildIndex();
        }
    }

    private void resetChildIndex() {
        for (int i = 0; i < this.entryChildren.length; ++i) {
            if (!this.entryChildren[i].getMessage().equals(this.entry.getMessage()) || !this.entryChildren[i].getDate().equals(this.entry.getDate()) || !this.entryChildren[i].getPluginId().equals(this.entry.getPluginId()) || this.entryChildren[i].getSeverity() != this.entry.getSeverity() || !this.entryChildren[i].getSeverityText().equals(this.entry.getSeverityText())) continue;
            this.childIndex = i;
            break;
        }
    }

    private void createImages() {
        this.imgCopyEnabled = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY").createImage(true);
        this.imgPrevEnabled = PDERuntimePluginImages.DESC_PREV_EVENT.createImage(true);
        this.imgNextEnabled = PDERuntimePluginImages.DESC_NEXT_EVENT.createImage(true);
    }

    private boolean isChild(LogEntry entry) {
        return entry.getParent((Object)entry) != null;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public int open() {
        this.isOpen = true;
        if (this.sashWeights == null) {
            int width = this.getSashForm().getClientArea().width;
            width = width - 100 > 0 ? (width -= 100) : (width /= 2);
            this.sashWeights = new int[]{width, this.getSashForm().getClientArea().width - width};
        }
        this.getSashForm().setWeights(this.sashWeights);
        return super.open();
    }

    public boolean close() {
        this.storeSettings();
        this.isOpen = false;
        this.imgCopyEnabled.dispose();
        this.imgNextEnabled.dispose();
        this.imgPrevEnabled.dispose();
        return super.close();
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        } else {
            this.getShell().setSize(500, 550);
        }
        EventDetailsDialog.applyDialogFont((Control)this.buttonBar);
        this.getButton(0).setFocus();
    }

    protected void buttonPressed(int buttonId) {
        if (0 == buttonId) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else if (14 == buttonId) {
            this.backPressed();
        } else if (15 == buttonId) {
            this.nextPressed();
        } else if (COPY_ID == buttonId) {
            this.copyPressed();
        }
    }

    protected void backPressed() {
        if (this.isChild(this.entry)) {
            if (this.childIndex > 0) {
                --this.childIndex;
                this.entry = this.entryChildren[this.childIndex];
            } else {
                this.entry = this.parentEntry;
            }
        } else {
            if (this.elementNum - 1 >= 0) {
                --this.elementNum;
            }
            this.entry = (LogEntry)((Object)this.provider.getElementAt(this.elementNum));
        }
        this.setEntrySelectionInTable();
    }

    protected void nextPressed() {
        if (this.isChild(this.entry) && this.childIndex < this.entryChildren.length - 1) {
            ++this.childIndex;
            this.entry = this.entryChildren[this.childIndex];
        } else if (this.elementNum + 1 < this.totalElementCount) {
            ++this.elementNum;
            this.entry = (LogEntry)((Object)this.provider.getElementAt(this.elementNum));
        } else {
            this.setEntryChildren(this.entry);
            this.entry = this.entryChildren[0];
        }
        this.setEntrySelectionInTable();
    }

    protected void copyPressed() {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        this.entry.write(pwriter);
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.updateProperties();
    }

    private void setComparator(byte sortType, final int sortOrder) {
        this.comparator = sortType == LogView.DATE ? new Comparator(){

            public int compare(Object e1, Object e2) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
                    Date date1 = formatter.parse(((LogEntry)((Object)e1)).getDate());
                    Date date2 = formatter.parse(((LogEntry)((Object)e2)).getDate());
                    if (sortOrder == ASCENDING) {
                        return date1.before(date2) ? -1 : 1;
                    }
                    return date1.after(date2) ? -1 : 1;
                }
                catch (ParseException parseException) {
                    return 0;
                }
            }
        } : (sortType == LogView.PLUGIN ? new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return EventDetailsDialog.this.collator.compare(entry1.getPluginId(), entry2.getPluginId()) * sortOrder;
            }
        } : new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return EventDetailsDialog.this.collator.compare(entry1.getMessage(), entry2.getMessage()) * sortOrder;
            }
        });
    }

    public void resetSelection(IAdaptable selectedEntry, byte sortType, int sortOrder) {
        this.setComparator(sortType, sortOrder);
        this.resetSelection(selectedEntry);
    }

    public void resetSelection(IAdaptable selectedEntry) {
        if (((Object)((Object)this.entry)).equals(selectedEntry) && this.elementNum == this.getParentElementNum()) {
            this.updateProperties();
            return;
        }
        this.entry = (LogEntry)selectedEntry;
        this.initialize();
        this.updateProperties();
    }

    public void resetButtons() {
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
    }

    private void setEntrySelectionInTable() {
        StructuredSelection selection = new StructuredSelection((Object)this.entry);
        this.provider.setSelection((ISelection)selection);
    }

    public void updateProperties() {
        if (this.isChild(this.entry)) {
            this.parentEntry = (LogEntry)((Object)this.entry.getParent((Object)this.entry));
            this.setEntryChildren(this.parentEntry);
            this.resetChildIndex();
        }
        this.totalElementCount = this.provider.getTableTree().getTable().getItemCount() - this.getVisibleChildrenCount();
        this.dateLabel.setText(this.entry.getDate());
        this.severityImageLabel.setImage(this.labelProvider.getColumnImage((Object)this.entry, 1));
        this.severityLabel.setText(this.entry.getSeverityText());
        this.msgText.setText(this.entry.getMessage());
        String stack = this.entry.getStack();
        if (stack != null) {
            this.stackTraceText.setText(stack);
        } else {
            this.stackTraceText.setText(PDERuntimePlugin.getResourceString(this.EVENT_NO_STACK));
        }
        LogSession session = this.entry.getSession();
        if (session != null && session.getSessionData() != null) {
            this.sessionDataText.setText(session.getSessionData());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean isAtEnd;
        boolean bl = isAtEnd = this.elementNum == this.totalElementCount - 1;
        if (this.isChild(this.entry)) {
            this.backButton.setEnabled(true);
            boolean isLastChild = this.childIndex == this.entryChildren.length - 1;
            this.nextButton.setEnabled(!isLastChild || !isAtEnd || this.entry.hasChildren());
        } else {
            this.backButton.setEnabled(this.elementNum != 0);
            this.nextButton.setEnabled(!isAtEnd || this.entry.hasChildren());
        }
    }

    private void setEntryChildren(LogEntry parent) {
        Object[] children = parent.getChildren((Object)parent);
        if (this.comparator != null) {
            Arrays.sort(children, this.comparator);
        }
        this.entryChildren = new LogEntry[children.length];
        System.arraycopy(children, 0, this.entryChildren, 0, children.length);
    }

    private int getParentElementNum() {
        LogEntry itemEntry = (LogEntry)((Object)((IStructuredSelection)this.provider.getSelection()).getFirstElement());
        itemEntry = this.getRootEntry(itemEntry);
        for (int i = 0; i < this.provider.getTableTree().getItemCount(); ++i) {
            try {
                LogEntry littleEntry = (LogEntry)((Object)this.provider.getElementAt(i));
                if (!((Object)((Object)itemEntry)).equals((Object)littleEntry)) continue;
                return i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private LogEntry getRootEntry(LogEntry entry) {
        if (!this.isChild(entry)) {
            return entry;
        }
        return this.getRootEntry((LogEntry)((Object)entry.getParent((Object)entry)));
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    private int getVisibleChildrenCount() {
        Object[] elements = this.provider.getVisibleExpandedElements();
        LogEntry[] expandedElements = new LogEntry[elements.length];
        System.arraycopy(elements, 0, expandedElements, 0, elements.length);
        int count = 0;
        for (int i = 0; i < expandedElements.length; ++i) {
            count += expandedElements[i].getChildren((Object)expandedElements[i]).length;
        }
        return count;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createDetailsSection(container);
        this.createSashForm(container);
        this.createStackSection((Composite)this.getSashForm());
        this.createSessionSection((Composite)this.getSashForm());
        this.updateProperties();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createSashForm(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.sashForm.setLayout((Layout)layout);
        this.sashForm.setLayoutData((Object)new GridData(1808));
    }

    private void createToolbarButtonBar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.backButton = this.createButton(container, 14, "", false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.backButton.setLayoutData((Object)gd);
        this.backButton.setToolTipText(PDERuntimePlugin.getResourceString(this.EVENT_PREVIOUS));
        this.backButton.setImage(this.imgPrevEnabled);
        this.nextButton = this.createButton(container, 15, "", false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.nextButton.setLayoutData((Object)gd);
        this.nextButton.setToolTipText(PDERuntimePlugin.getResourceString(this.EVENT_NEXT));
        this.nextButton.setImage(this.imgNextEnabled);
        this.copyButton = this.createButton(container, COPY_ID, "", false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.copyButton.setLayoutData((Object)gd);
        this.copyButton.setImage(this.imgCopyEnabled);
        this.copyButton.setToolTipText(PDERuntimePlugin.getResourceString(this.EVENT_COPY));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void createDetailsSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.createTextSection(container);
        this.createToolbarButtonBar(container);
    }

    private void createTextSection(Composite parent) {
        Composite textContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textContainer.setLayout((Layout)layout);
        textContainer.setLayoutData((Object)new GridData(768));
        Label label = new Label(textContainer, 0);
        label.setText(PDERuntimePlugin.getResourceString("EventDetailsDialog.date"));
        this.dateLabel = new Label(textContainer, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.dateLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText(PDERuntimePlugin.getResourceString("EventDetailsDialog.severity"));
        this.severityImageLabel = new Label(textContainer, 0);
        this.severityLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        this.severityLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText(PDERuntimePlugin.getResourceString("EventDetailsDialog.message"));
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.msgText = new Text(textContainer, 2626);
        this.msgText.setEditable(false);
        gd = new GridData(1810);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 8;
        gd.grabExcessVerticalSpace = true;
        this.msgText.setLayoutData((Object)gd);
    }

    private void createStackSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(PDERuntimePlugin.getResourceString("EventDetailsDialog.exception"));
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.stackTraceText = new Text(container, 2818);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        this.stackTraceText.setLayoutData((Object)gd);
        this.stackTraceText.setEditable(false);
    }

    private void createSessionSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label line = new Label(container, 258);
        gd = new GridData(256);
        gd.widthHint = 1;
        line.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(PDERuntimePlugin.getResourceString("EventDetailsDialog.session"));
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.sessionDataText = new Text(container, 2816);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        this.sessionDataText.setLayoutData((Object)gd);
        this.sessionDataText.setEditable(false);
    }

    private void storeSettings() {
        this.writeConfiguration();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDERuntimePlugin.getDefault().getDialogSettings();
        this.dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
            this.sashWeights = new int[2];
            this.sashWeights[0] = s.getInt("sashWidth1");
            this.sashWeights[1] = s.getInt("sashWidth2");
        }
        catch (NumberFormatException e) {
            this.dialogLocation = null;
            this.dialogSize = null;
            this.sashWeights = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
        this.sashWeights = this.getSashForm().getWeights();
        s.put("sashWidth1", this.sashWeights[0]);
        s.put("sashWidth2", this.sashWeights[1]);
    }
}

