/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal.jdwp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.eclipse.jdi.internal.jdwp.JDWPMessages;

public class JdwpString {
    public static String read(DataInputStream in) throws IOException {
        int utfSize = in.readInt();
        byte[] utfBytes = new byte[utfSize];
        in.readFully(utfBytes);
        StringBuffer strBuffer = new StringBuffer(utfSize / 3 * 2);
        int i = 0;
        while (i < utfSize) {
            int a = utfBytes[i] & 0xFF;
            if (a >> 4 < 12) {
                strBuffer.append((char)a);
                ++i;
                continue;
            }
            int b = utfBytes[i + 1] & 0xFF;
            if (a >> 4 < 14) {
                if ((b & 0xBF) == 0) {
                    throw new UTFDataFormatException(JDWPMessages.getString("JdwpString.Second_byte_input_does_not_match_UTF_Specification_1"));
                }
                strBuffer.append((char)((a & 0x1F) << 6 | b & 0x3F));
                i += 2;
                continue;
            }
            int c = utfBytes[i + 2] & 0xFF;
            if ((a & 0xEF) > 0) {
                if ((b & 0xBF) == 0 || (c & 0xBF) == 0) {
                    throw new UTFDataFormatException(JDWPMessages.getString("JdwpString.Second_or_third_byte_input_does_not_mach_UTF_Specification_2"));
                }
                strBuffer.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
                i += 3;
                continue;
            }
            throw new UTFDataFormatException(JDWPMessages.getString("JdwpString.Input_does_not_match_UTF_Specification_3"));
        }
        return strBuffer.toString();
    }

    public static void write(String str, DataOutputStream out) throws IOException {
        if (str == null) {
            throw new NullPointerException(JDWPMessages.getString("JdwpString.str_is_null_4"));
        }
        int utfCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                ++utfCount;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfCount += 2;
                continue;
            }
            utfCount += 3;
        }
        byte[] utfBytes = new byte[utfCount];
        int utfIndex = 0;
        for (int i = 0; i < str.length(); ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                utfBytes[utfIndex++] = (byte)charValue;
                continue;
            }
            if (charValue <= '\u07ff') {
                utfBytes[utfIndex++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
                continue;
            }
            utfBytes[utfIndex++] = (byte)(0xE0 | 0xF & charValue >> 12);
            utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue >> 6);
            utfBytes[utfIndex++] = (byte)(0x80 | 0x3F & charValue);
        }
        out.writeInt(utfCount);
        if (utfCount > 0) {
            out.write(utfBytes);
        }
    }
}

