/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareDialog;
import org.eclipse.compare.internal.CompareFilter;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.ComparePreferencePage;
import org.eclipse.compare.internal.IViewerDescriptor;
import org.eclipse.compare.internal.SimpleTextViewer;
import org.eclipse.compare.internal.StreamMergerDescriptor;
import org.eclipse.compare.internal.StructureCreatorDescriptor;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerDescriptor;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IStructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureDiffViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class CompareUIPlugin
extends AbstractUIPlugin {
    public static final String DTOOL_NEXT = "dlcl16/next_nav.gif";
    public static final String ETOOL_NEXT = "elcl16/next_nav.gif";
    public static final String CTOOL_NEXT = "elcl16/next_nav.gif";
    public static final String DTOOL_PREV = "dlcl16/prev_nav.gif";
    public static final String ETOOL_PREV = "elcl16/prev_nav.gif";
    public static final String CTOOL_PREV = "elcl16/prev_nav.gif";
    public static final int INTERNAL_ERROR = 1;
    private static boolean NORMALIZE_CASE = true;
    public static final String PLUGIN_ID = "org.eclipse.compare";
    private static final String BINARY_TYPE = "binary";
    private static final String STREAM_MERGER_EXTENSION_POINT = "streamMergers";
    private static final String STREAM_MERGER = "streamMerger";
    private static final String STREAM_MERGER_ID_ATTRIBUTE = "streamMergerId";
    private static final String STRUCTURE_CREATOR_EXTENSION_POINT = "structureCreators";
    private static final String STRUCTURE_CREATOR = "structureCreator";
    private static final String STRUCTURE_CREATOR_ID_ATTRIBUTE = "structureCreatorId";
    private static final String VIEWER_TAG = "viewer";
    private static final String STRUCTURE_MERGE_VIEWER_EXTENSION_POINT = "structureMergeViewers";
    private static final String STRUCTURE_MERGE_VIEWER_ID_ATTRIBUTE = "structureMergeViewerId";
    private static final String CONTENT_MERGE_VIEWER_EXTENSION_POINT = "contentMergeViewers";
    private static final String CONTENT_MERGE_VIEWER_ID_ATTRIBUTE = "contentMergeViewerId";
    private static final String CONTENT_VIEWER_EXTENSION_POINT = "contentViewers";
    private static final String CONTENT_VIEWER_ID_ATTRIBUTE = "contentViewerId";
    private static final String CONTENT_TYPE_BINDING = "contentTypeBinding";
    private static final String COMPARE_EDITOR = "org.eclipse.compare.CompareEditor";
    private static final String STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME = "StructureViewerAliases";
    private static final IContentTypeManager fgContentTypeManager = Platform.getContentTypeManager();
    private static final IContentType CT_TEXT = fgContentTypeManager.getContentType("org.eclipse.core.runtime.text");
    private static CompareUIPlugin fgComparePlugin;
    private static Map fgImages;
    private static Map fgImageDescriptors;
    private static Map fgImages2;
    private static List fgDisposeOnShutdownImages;
    private ResourceBundle fResourceBundle;
    private CompareRegistry fStreamMergers = new CompareRegistry();
    private CompareRegistry fStructureCreators = new CompareRegistry();
    private CompareRegistry fStructureMergeViewers = new CompareRegistry();
    private CompareRegistry fContentViewers = new CompareRegistry();
    private CompareRegistry fContentMergeViewers = new CompareRegistry();
    private Map fStructureViewerAliases = new Hashtable(10);
    private CompareFilter fFilter;
    private IPropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public CompareUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        Assert.isTrue((fgComparePlugin == null ? 1 : 0) != 0);
        fgComparePlugin = this;
        this.fResourceBundle = descriptor.getResourceBundle();
        this.registerExtensions();
        this.initPreferenceStore();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        ComparePreferencePage.initDefaults(store);
    }

    public static CompareUIPlugin getDefault() {
        return fgComparePlugin;
    }

    public ResourceBundle getResourceBundle() {
        return CompareUIPlugin.getDefault().fResourceBundle;
    }

    public static String getPluginId() {
        return CompareUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    private void registerExtensions() {
        String name;
        IConfigurationElement element;
        int i;
        IPluginRegistry registry = Platform.getPluginRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PLUGIN_ID, STREAM_MERGER_EXTENSION_POINT);
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            if (!STREAM_MERGER.equals(element.getName())) continue;
            this.fStreamMergers.register(element, new StreamMergerDescriptor(element));
        }
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            if (!CONTENT_TYPE_BINDING.equals(element.getName())) continue;
            this.fStreamMergers.createBinding(element, STREAM_MERGER_ID_ATTRIBUTE);
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_CREATOR_EXTENSION_POINT);
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            name = element.getName();
            if (CONTENT_TYPE_BINDING.equals(name)) continue;
            if (!STRUCTURE_CREATOR.equals(name)) {
                CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, STRUCTURE_CREATOR));
            }
            this.fStructureCreators.register(element, new StructureCreatorDescriptor(element));
        }
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            if (!CONTENT_TYPE_BINDING.equals(element.getName())) continue;
            this.fStructureCreators.createBinding(element, STRUCTURE_CREATOR_ID_ATTRIBUTE);
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, STRUCTURE_MERGE_VIEWER_EXTENSION_POINT);
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            name = element.getName();
            if (CONTENT_TYPE_BINDING.equals(name)) continue;
            if (!VIEWER_TAG.equals(name)) {
                CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
            }
            this.fStructureMergeViewers.register(element, new ViewerDescriptor(element));
        }
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            if (!CONTENT_TYPE_BINDING.equals(element.getName())) continue;
            this.fStructureMergeViewers.createBinding(element, STRUCTURE_MERGE_VIEWER_ID_ATTRIBUTE);
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_MERGE_VIEWER_EXTENSION_POINT);
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            name = element.getName();
            if (CONTENT_TYPE_BINDING.equals(name)) continue;
            if (!VIEWER_TAG.equals(name)) {
                CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
            }
            this.fContentMergeViewers.register(element, new ViewerDescriptor(element));
        }
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            if (!CONTENT_TYPE_BINDING.equals(element.getName())) continue;
            this.fContentMergeViewers.createBinding(element, CONTENT_MERGE_VIEWER_ID_ATTRIBUTE);
        }
        elements = registry.getConfigurationElementsFor(PLUGIN_ID, CONTENT_VIEWER_EXTENSION_POINT);
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            name = element.getName();
            if (CONTENT_TYPE_BINDING.equals(name)) continue;
            if (!VIEWER_TAG.equals(name)) {
                CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.unexpectedTag", name, VIEWER_TAG));
            }
            this.fContentViewers.register(element, new ViewerDescriptor(element));
        }
        for (i = 0; i < elements.length; ++i) {
            element = elements[i];
            if (!CONTENT_TYPE_BINDING.equals(element.getName())) continue;
            this.fContentViewers.createBinding(element, CONTENT_VIEWER_ID_ATTRIBUTE);
        }
    }

    public static IWorkbench getActiveWorkbench() {
        CompareUIPlugin plugin = CompareUIPlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getWorkbench();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = CompareUIPlugin.getActiveWorkbench();
        if (workbench == null) {
            return null;
        }
        return workbench.getActiveWorkbenchWindow();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static Shell getShell() {
        IWorkbenchWindow window = CompareUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static void disposeOnShutdown(Image image) {
        if (image != null) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public void shutdown() throws CoreException {
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps != null) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = this.fStructureViewerAliases.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String alias = (String)this.fStructureViewerAliases.get(key);
                sb.append(key);
                sb.append('.');
                sb.append(alias);
                sb.append(' ');
            }
            ps.setValue(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME, sb.toString());
            if (this.fPropertyChangeListener != null) {
                ps.removePropertyChangeListener(this.fPropertyChangeListener);
                this.fPropertyChangeListener = null;
            }
        }
        super.shutdown();
        if (fgDisposeOnShutdownImages != null) {
            Iterator i = fgDisposeOnShutdownImages.iterator();
            while (i.hasNext()) {
                Image img = (Image)i.next();
                if (img.isDisposed()) continue;
                img.dispose();
            }
            fgImages = null;
        }
    }

    public void openCompareEditor(CompareEditorInput input, IWorkbenchPage page, IReusableEditor editor) {
        if (this.compareResultOK(input)) {
            if (editor != null) {
                editor.setInput((IEditorInput)input);
                return;
            }
            if (page == null) {
                page = CompareUIPlugin.getActivePage();
            }
            if (page != null) {
                try {
                    page.openEditor((IEditorInput)input, COMPARE_EDITOR);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)e.getMessage());
                }
            } else {
                MessageDialog.openError((Shell)CompareUIPlugin.getShell(), (String)Utilities.getString("CompareUIPlugin.openEditorError"), (String)Utilities.getString("CompareUIPlugin.noActiveWorkbenchPage"));
            }
        }
    }

    public void openCompareDialog(CompareEditorInput input) {
        if (this.compareResultOK(input)) {
            CompareDialog dialog = new CompareDialog(CompareUIPlugin.getShell(), input);
            dialog.open();
        }
    }

    private boolean compareResultOK(CompareEditorInput input) {
        Shell shell = CompareUIPlugin.getShell();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)input);
            String message = input.getMessage();
            if (message != null) {
                MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)message);
                return false;
            }
            if (input.getCompareResult() == null) {
                MessageDialog.openInformation((Shell)shell, (String)Utilities.getString("CompareUIPlugin.dialogTitle"), (String)Utilities.getString("CompareUIPlugin.noDifferences"));
                return false;
            }
            return true;
        }
        catch (InterruptedException x) {
        }
        catch (InvocationTargetException x) {
            MessageDialog.openError((Shell)shell, (String)Utilities.getString("CompareUIPlugin.compareFailed"), (String)x.getTargetException().getMessage());
        }
        return false;
    }

    private static void registerImage(String type, Image image, boolean dispose) {
        fgImages.put(CompareUIPlugin.normalizeCase(type), image);
        if (image != null && dispose) {
            fgDisposeOnShutdownImages.add(image);
        }
    }

    public static void registerImageDescriptor(String type, ImageDescriptor descriptor) {
        fgImageDescriptors.put(CompareUIPlugin.normalizeCase(type), descriptor);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        URL installURL = null;
        if (fgComparePlugin != null) {
            installURL = fgComparePlugin.getDescriptor().getInstallURL();
        }
        if (installURL != null) {
            try {
                URL url = new URL(installURL, Utilities.getIconPath(null) + relativePath);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (MalformedURLException e) {
                Assert.isTrue((boolean)false);
            }
        }
        return null;
    }

    public static Image getImage(String type) {
        type = CompareUIPlugin.normalizeCase(type);
        boolean dispose = false;
        Image image = null;
        if (type != null) {
            image = (Image)fgImages.get(type);
        }
        if (image == null) {
            ImageDescriptor id = (ImageDescriptor)fgImageDescriptors.get(type);
            if (id != null) {
                image = id.createImage();
                dispose = true;
            }
            if (image == null) {
                if (fgComparePlugin != null) {
                    if ("FOLDER".equals(type)) {
                        image = CompareUIPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                    } else {
                        image = CompareUIPlugin.createWorkbenchImage(type);
                        dispose = true;
                    }
                } else {
                    id = (ImageDescriptor)fgImageDescriptors.get(CompareUIPlugin.normalizeCase("file"));
                    image = id.createImage();
                    dispose = true;
                }
            }
            if (image != null) {
                CompareUIPlugin.registerImage(type, image, dispose);
            }
        }
        return image;
    }

    public static Image getImage(IAdaptable adaptable) {
        ImageDescriptor id;
        Object o;
        if (adaptable != null && (o = adaptable.getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = CompareUIPlugin.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) instanceof IWorkbenchAdapter && (id = ((IWorkbenchAdapter)o).getImageDescriptor((Object)adaptable)) != null) {
            Image image = (Image)fgImages2.get(id);
            if (image == null) {
                image = id.createImage();
                try {
                    fgImages2.put(id, image);
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                fgDisposeOnShutdownImages.add(image);
            }
            return image;
        }
        return null;
    }

    private static Image createWorkbenchImage(String type) {
        IEditorRegistry er = CompareUIPlugin.getDefault().getWorkbench().getEditorRegistry();
        ImageDescriptor id = er.getImageDescriptor("foo." + type);
        return id.createImage();
    }

    public StructureCreatorDescriptor getStructureCreator(String type) {
        return (StructureCreatorDescriptor)this.fStructureCreators.search(type);
    }

    public IStreamMerger createStreamMerger(String type) {
        StreamMergerDescriptor descriptor = (StreamMergerDescriptor)this.fStreamMergers.search(type);
        if (descriptor != null) {
            return descriptor.createStreamMerger();
        }
        return null;
    }

    public IStreamMerger createStreamMerger(IContentType type) {
        StreamMergerDescriptor descriptor = (StreamMergerDescriptor)this.fStreamMergers.search(type);
        if (descriptor != null) {
            return descriptor.createStreamMerger();
        }
        return null;
    }

    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
        IStructureCreator sc;
        Viewer viewer;
        if (input.getLeft() == null || input.getRight() == null) {
            return null;
        }
        IContentType ctype = CompareUIPlugin.getCommonType(CompareUIPlugin.getContentTypes(input));
        if (ctype != null && (viewer = CompareUIPlugin.getViewer(this.fStructureMergeViewers.search(ctype), oldViewer, parent, configuration)) != null) {
            return viewer;
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            String alias;
            type = CompareUIPlugin.normalizeCase(types[0]);
            IViewerDescriptor vd = (IViewerDescriptor)this.fStructureMergeViewers.search(type);
            if (vd == null && (alias = (String)this.fStructureViewerAliases.get(type)) != null) {
                vd = (IViewerDescriptor)this.fStructureMergeViewers.search(alias);
            }
            if (vd != null) {
                return vd.createViewer(oldViewer, parent, configuration);
            }
        }
        StructureCreatorDescriptor scc = null;
        Object desc = this.fStructureCreators.search(ctype);
        if (desc instanceof StructureCreatorDescriptor) {
            scc = (StructureCreatorDescriptor)desc;
        }
        if (scc == null && type != null) {
            scc = this.getStructureCreator(type);
        }
        if (scc != null && (sc = scc.createStructureCreator()) != null) {
            StructureDiffViewer sdv = new StructureDiffViewer(parent, configuration);
            sdv.setStructureCreator(sc);
            return sdv;
        }
        return null;
    }

    public Viewer findContentViewer(Viewer oldViewer, Object in, Composite parent, CompareConfiguration cc) {
        Viewer viewer;
        Viewer viewer2;
        if (in instanceof IStreamContentAccessor) {
            Viewer viewer3;
            String type = "txt";
            if (in instanceof ITypedElement) {
                Viewer viewer4;
                ITypedElement tin = (ITypedElement)in;
                IContentType ct = CompareUIPlugin.getContentType(tin);
                if (ct != null && (viewer4 = CompareUIPlugin.getViewer(this.fContentViewers.search(ct), oldViewer, parent, cc)) != null) {
                    return viewer4;
                }
                String ty = tin.getType();
                if (ty != null) {
                    type = ty;
                }
            }
            if ((viewer3 = CompareUIPlugin.getViewer(this.fContentViewers.search(type), oldViewer, parent, cc)) != null) {
                return viewer3;
            }
            return new SimpleTextViewer(parent);
        }
        if (!(in instanceof ICompareInput)) {
            return null;
        }
        ICompareInput input = (ICompareInput)in;
        IContentType ctype = CompareUIPlugin.getCommonType(CompareUIPlugin.getContentTypes(input));
        if (ctype != null && (viewer2 = CompareUIPlugin.getViewer(this.fContentMergeViewers.search(ctype), oldViewer, parent, cc)) != null) {
            return viewer2;
        }
        String[] types = CompareUIPlugin.getTypes(input);
        String type = null;
        if (CompareUIPlugin.isHomogenous(types)) {
            type = types[0];
        }
        if ("FOLDER".equals(type)) {
            return null;
        }
        if (type == null) {
            int n = 0;
            for (int i = 0; i < types.length; ++i) {
                if ("???".equals(types[i])) continue;
                ++n;
                if (type != null) continue;
                type = types[i];
            }
            if (n > 1) {
                type = null;
            }
        }
        if (type != null && (viewer = CompareUIPlugin.getViewer(this.fContentMergeViewers.search(type), oldViewer, parent, cc)) != null) {
            return viewer;
        }
        String leftType = CompareUIPlugin.guessType(input.getLeft());
        String rightType = CompareUIPlugin.guessType(input.getRight());
        if (leftType != null || rightType != null) {
            boolean right_text = rightType != null && "txt".equals(rightType);
            boolean left_text = leftType != null && "txt".equals(leftType);
            type = leftType == null && right_text || left_text && rightType == null || left_text && right_text ? "txt" : BINARY_TYPE;
            IViewerDescriptor vd = (IViewerDescriptor)this.fContentMergeViewers.search(type);
            if (vd != null) {
                return vd.createViewer(oldViewer, parent, cc);
            }
        }
        return null;
    }

    private static Viewer getViewer(Object descriptor, Viewer oldViewer, Composite parent, CompareConfiguration cc) {
        if (descriptor instanceof IViewerDescriptor) {
            return ((IViewerDescriptor)descriptor).createViewer(oldViewer, parent, cc);
        }
        return null;
    }

    private static String[] getTypes(ICompareInput input) {
        String type;
        ITypedElement ancestor = input.getAncestor();
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        ArrayList<String> tmp = new ArrayList<String>();
        if (ancestor != null && (type = ancestor.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        if (left != null && (type = left.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        if (right != null && (type = right.getType()) != null) {
            tmp.add(CompareUIPlugin.normalizeCase(type));
        }
        return tmp.toArray(new String[tmp.size()]);
    }

    private static IContentType[] getContentTypes(ICompareInput input) {
        ITypedElement ancestor = input.getAncestor();
        ITypedElement left = input.getLeft();
        ITypedElement right = input.getRight();
        ArrayList<IContentType> tmp = new ArrayList<IContentType>();
        IContentType type = CompareUIPlugin.getContentType(ancestor);
        if (type != null) {
            tmp.add(type);
        }
        if ((type = CompareUIPlugin.getContentType(left)) != null) {
            tmp.add(type);
        }
        if ((type = CompareUIPlugin.getContentType(right)) != null) {
            tmp.add(type);
        }
        return tmp.toArray(new IContentType[tmp.size()]);
    }

    private static IContentType getContentType(ITypedElement element) {
        IContentType ct;
        block9: {
            if (element == null) {
                return null;
            }
            String name = element.getName();
            IContentType[] associated = fgContentTypeManager.findContentTypesFor(name);
            if (associated.length > 0) {
                return associated[0];
            }
            ct = null;
            if (element instanceof IStreamContentAccessor) {
                IStreamContentAccessor isa = (IStreamContentAccessor)((Object)element);
                try {
                    InputStream is = isa.getContents();
                    if (is == null) break block9;
                    BufferedInputStream bis = new BufferedInputStream(is);
                    try {
                        ct = fgContentTypeManager.findContentTypeFor(is, name);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        ((InputStream)bis).close();
                    }
                    catch (IOException e2) {}
                }
                catch (CoreException e1) {
                    // empty catch block
                }
            }
        }
        return ct;
    }

    private static boolean isHomogenous(String[] types) {
        switch (types.length) {
            case 1: {
                return true;
            }
            case 2: {
                return types[0].equals(types[1]);
            }
            case 3: {
                return types[0].equals(types[1]) && types[1].equals(types[2]);
            }
        }
        return false;
    }

    private static IContentType getCommonType(IContentType[] types) {
        Set s = null;
        ArrayList l = null;
        switch (types.length) {
            case 1: {
                return types[0];
            }
            case 2: {
                l = new ArrayList();
                s = CompareUIPlugin.toSet(l, types[0]);
                s.retainAll(CompareUIPlugin.toSet(l, types[1]));
                break;
            }
            case 3: {
                l = new ArrayList();
                s = CompareUIPlugin.toSet(l, types[0]);
                s.retainAll(CompareUIPlugin.toSet(l, types[1]));
                s.retainAll(CompareUIPlugin.toSet(l, types[2]));
            }
        }
        if (s != null && !s.isEmpty()) {
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                IContentType ct = (IContentType)iter.next();
                if (!s.contains(ct)) continue;
                return ct;
            }
        }
        return null;
    }

    private static Set toSet(ArrayList l, IContentType ct) {
        HashSet<IContentType> set = new HashSet<IContentType>();
        while (ct != null) {
            l.add(ct);
            set.add(ct);
            ct = ct.getBaseType();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String guessType(ITypedElement input) {
        block19: {
            block18: {
                block17: {
                    if (input instanceof IStreamContentAccessor == false) return null;
                    sca = (IStreamContentAccessor)input;
                    is = null;
                    try {
                        try {
                            is = sca.getContents();
                            if (is == null) {
                                var3_3 = null;
                                var8_7 = null;
                                if (is == null) return var3_3;
                                break block17;
                            }
                            lineLength = 0;
                            lines = 0;
                            while (lines < 10 && (c = is.read()) != -1) {
                                if (c == 10 || c == 13) {
                                    lineLength = 0;
                                    ++lines;
                                } else {
                                    ++lineLength;
                                }
                                if (lineLength <= 1000) continue;
                                var6_22 = "???";
                                break block18;
                            }
                            var5_21 = "txt";
                            break block19;
                        }
                        catch (CoreException ex) {
                            var8_10 = null;
                            if (is == null) return "???";
                            try {
                                is.close();
                                return "???";
                            }
                            catch (IOException ex) {
                                return "???";
                            }
                        }
                        catch (IOException var3_6) {
                            var8_11 = null;
                            if (is == null) return "???";
                            try {}
                            catch (IOException ex) {
                                return "???";
                            }
                            is.close();
                            return "???";
                        }
                    }
                    catch (Throwable var7_23) {
                        var8_12 = null;
                        if (is == null) throw var7_23;
                        ** try [egrp 2[TRYBLOCK] [12 : 142->149)] { 
lbl51:
                        // 1 sources

                        is.close();
                        throw var7_23;
lbl53:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                        throw var7_23;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [12 : 142->149)] { 
lbl58:
                // 1 sources

                is.close();
                return var3_3;
lbl60:
                // 1 sources

                catch (IOException ex) {
                    // empty catch block
                }
                return var3_3;
            }
            var8_8 = null;
            if (is == null) return var6_22;
            ** try [egrp 2[TRYBLOCK] [12 : 142->149)] { 
lbl67:
            // 1 sources

            is.close();
            return var6_22;
lbl69:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return var6_22;
        }
        var8_9 = null;
        if (is == null) return var5_21;
        try {}
        catch (IOException ex) {
            // empty catch block
            return var5_21;
        }
        is.close();
        return var5_21;
    }

    private static String normalizeCase(String s) {
        if (NORMALIZE_CASE && s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    private void initPreferenceStore() {
        final IPreferenceStore ps = this.getPreferenceStore();
        if (ps != null) {
            String aliases = ps.getString(STRUCTUREVIEWER_ALIASES_PREFERENCE_NAME);
            if (aliases != null && aliases.length() > 0) {
                StringTokenizer st = new StringTokenizer(aliases, " ");
                while (st.hasMoreTokens()) {
                    String pair = st.nextToken();
                    int pos = pair.indexOf(46);
                    if (pos <= 0) continue;
                    String key = pair.substring(0, pos);
                    String alias = pair.substring(pos + 1);
                    this.fStructureViewerAliases.put(key, alias);
                }
            }
            this.fFilter = new CompareFilter();
            this.fFilter.setFilters(ps.getString("org.eclipse.compare.PathFilter"));
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("org.eclipse.compare.PathFilter".equals(event.getProperty())) {
                        CompareUIPlugin.this.fFilter.setFilters(ps.getString("org.eclipse.compare.PathFilter"));
                    }
                }
            };
            ps.addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public void addStructureViewerAlias(String type, String alias) {
        this.fStructureViewerAliases.put(CompareUIPlugin.normalizeCase(alias), CompareUIPlugin.normalizeCase(type));
    }

    public void removeAllStructureViewerAliases(String type) {
        String t = CompareUIPlugin.normalizeCase(type);
        Set entrySet = this.fStructureViewerAliases.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!entry.getValue().equals(t)) continue;
            iter.remove();
        }
    }

    public static IEditorPart[] getDirtyEditors() {
        HashSet<IEditorInput> inputs = new HashSet<IEditorInput>();
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(0);
        IWorkbench workbench = CompareUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        for (int i = 0; i < windows.length; ++i) {
            IWorkbenchPage[] pages = windows[i].getPages();
            for (int x = 0; x < pages.length; ++x) {
                IEditorPart[] editors = pages[x].getDirtyEditors();
                for (int z = 0; z < editors.length; ++z) {
                    IEditorPart ep = editors[z];
                    IEditorInput input = ep.getEditorInput();
                    if (inputs.contains(input)) continue;
                    inputs.add(input);
                    result.add(ep);
                }
            }
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    public boolean filter(String name, boolean isFolder, boolean isArchive) {
        if (this.fFilter != null) {
            return this.fFilter.filter(name, isFolder, isArchive);
        }
        return false;
    }

    public static void logErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        CompareUIPlugin.log((IStatus)new Status(4, CompareUIPlugin.getPluginId(), 1, message, null));
    }

    public static void log(Throwable e) {
        CompareUIPlugin.log((IStatus)new Status(4, CompareUIPlugin.getPluginId(), 1, CompareMessages.getString("ComparePlugin.internal_error"), e));
    }

    public static void log(IStatus status) {
        CompareUIPlugin.getDefault().getLog().log(status);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fgImages = new Hashtable(10);
        fgImageDescriptors = new Hashtable(10);
        fgImages2 = new Hashtable(10);
        fgDisposeOnShutdownImages = new ArrayList();
    }

    static class CompareRegistry {
        private static final String ID_ATTRIBUTE = "id";
        private static final String EXTENSIONS_ATTRIBUTE = "extensions";
        private static final String CONTENT_TYPE_ID_ATTRIBUTE = "contentTypeId";
        private HashMap fIdMap;
        private HashMap fExtensionMap;
        private HashMap fContentTypeBindings;

        CompareRegistry() {
        }

        void register(IConfigurationElement element, Object data) {
            String types;
            String id = element.getAttribute(ID_ATTRIBUTE);
            if (id != null) {
                if (this.fIdMap == null) {
                    this.fIdMap = new HashMap();
                }
                this.fIdMap.put(id, data);
            }
            if ((types = element.getAttribute(EXTENSIONS_ATTRIBUTE)) != null) {
                if (this.fExtensionMap == null) {
                    this.fExtensionMap = new HashMap();
                }
                StringTokenizer tokenizer = new StringTokenizer(types, ",");
                while (tokenizer.hasMoreElements()) {
                    String extension = tokenizer.nextToken().trim();
                    this.fExtensionMap.put(CompareUIPlugin.normalizeCase(extension), data);
                }
            }
        }

        void createBinding(IConfigurationElement element, String idAttributeName) {
            String type = element.getAttribute(CONTENT_TYPE_ID_ATTRIBUTE);
            String id = element.getAttribute(idAttributeName);
            if (id == null) {
                CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.targetIdAttributeMissing", idAttributeName));
            }
            if (type != null && id != null && this.fIdMap != null) {
                Object o = this.fIdMap.get(id);
                if (o != null) {
                    IContentType ct = fgContentTypeManager.getContentType(type);
                    if (ct != null) {
                        if (this.fContentTypeBindings == null) {
                            this.fContentTypeBindings = new HashMap();
                        }
                        this.fContentTypeBindings.put(ct, o);
                    } else {
                        CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.contentTypeNotFound", type));
                    }
                } else {
                    CompareUIPlugin.logErrorMessage(Utilities.getFormattedString("CompareUIPlugin.targetNotFound", id));
                }
            }
        }

        Object search(IContentType type) {
            if (type != null && this.fContentTypeBindings != null) {
                Object b = this.fContentTypeBindings.get(type);
                if (b != null) {
                    return b;
                }
                Iterator iter = this.fContentTypeBindings.keySet().iterator();
                while (iter.hasNext()) {
                    IContentType ct = (IContentType)iter.next();
                    if (!type.isKindOf(ct)) continue;
                    return this.fContentTypeBindings.get(ct);
                }
            }
            return null;
        }

        Object search(String extension) {
            if (this.fExtensionMap != null) {
                return this.fExtensionMap.get(CompareUIPlugin.normalizeCase(extension));
            }
            return null;
        }
    }
}

