/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.properties.IVisitor;
import org.eclipse.core.internal.properties.IndexedStoreWrapper;
import org.eclipse.core.internal.properties.QueryResults;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.properties.StoreKey;
import org.eclipse.core.internal.properties.StoredProperty;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class PropertyStore {
    protected IndexedStoreWrapper store = null;
    public static final int CREATE = 0;
    public static final int UPDATE = 1;
    public static final int SET_UPDATE = 2;
    public static final int SET_SKIP = 3;
    public static final int IGNORE_MISSING = 0;
    public static final int FAIL_MISSING = 1;

    public PropertyStore(IPath location) {
        this.store = new IndexedStoreWrapper(location);
    }

    protected boolean basicExists(StoreKey searchKey) throws CoreException {
        byte[] searchBytes = searchKey.toBytes();
        IndexCursor cursor = this.store.getCursor();
        try {
            cursor.find(searchBytes);
            boolean exists = cursor.keyEquals(searchBytes);
            cursor.close();
            return exists;
        }
        catch (Exception e) {
            String message = Policy.bind("properties.couldNotReadProp", searchKey.getQualifier(), searchKey.getLocalName());
            throw new ResourceException(271, searchKey.getResourceName().getPath(), message, e);
        }
    }

    protected void basicInsert(StoreKey key, String value) throws CoreException {
        try {
            ObjectID valueID = this.store.createObject(value);
            this.store.getIndex().insert(key.toBytes(), (Insertable)valueID);
        }
        catch (Exception e) {
            String message = Policy.bind("properties.couldNotWriteProp", key.getQualifier(), key.getLocalName());
            throw new ResourceException(272, key.getResourceName().getPath(), message, e);
        }
    }

    protected boolean basicRemove(ResourceName resourceName, QualifiedName propertyName) throws CoreException {
        StoreKey key = new StoreKey(resourceName, propertyName);
        byte[] keyBytes = key.toBytes();
        boolean wasFound = false;
        IndexCursor cursor = this.store.getCursor();
        try {
            cursor.find(keyBytes);
            if (cursor.keyEquals(keyBytes)) {
                wasFound = true;
                ObjectID valueID = cursor.getValueAsObjectID();
                this.store.removeObject(valueID);
                cursor.remove();
            }
            cursor.close();
        }
        catch (Exception e) {
            String message = Policy.bind("properties.couldNotDeleteProp", key.getQualifier(), key.getLocalName());
            throw new ResourceException(273, resourceName.getPath(), message, e);
        }
        return wasFound;
    }

    protected void basicUpdate(StoreKey key, String value) throws CoreException {
        byte[] keyBytes = key.toBytes();
        IndexCursor cursor = this.store.getCursor();
        try {
            cursor.find(keyBytes);
            if (cursor.keyEquals(keyBytes)) {
                ObjectID oldID = cursor.getValueAsObjectID();
                this.store.removeObject(oldID);
                ObjectID newValueId = this.store.createObject(value);
                cursor.updateValue(newValueId);
            }
            cursor.close();
        }
        catch (Exception e) {
            String message = Policy.bind("properties.couldNotWriteProp", key.getQualifier(), key.getLocalName());
            throw new ResourceException(272, key.getResourceName().getPath(), message, e);
        }
    }

    protected synchronized void commonSet(ResourceName resourceName, StoredProperty[] properties, int depth, int setMode, QueryResults failures) throws CoreException {
        if (depth == 0) {
            for (int i = 0; i < properties.length; ++i) {
                StoredProperty property = properties[i];
                StoreKey key = new StoreKey(resourceName, property.getName());
                boolean exists = this.basicExists(key);
                if (exists && setMode == 0 || !exists && setMode == 1) {
                    failures.add(resourceName, property);
                    continue;
                }
                if (exists && setMode != 3) {
                    this.basicUpdate(key, property.getStringValue());
                    continue;
                }
                this.basicInsert(key, property.getStringValue());
            }
        } else {
            Enumeration resourceNamesEnum = this.deepResourceNames(resourceName);
            while (resourceNamesEnum.hasMoreElements()) {
                this.commonSet((ResourceName)resourceNamesEnum.nextElement(), properties, 0, setMode, failures);
            }
        }
    }

    public Enumeration deepResourceNames(ResourceName resourceName) throws CoreException {
        final HashSet resultHolder = new HashSet(10);
        IVisitor visitor = new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty property, IndexCursor cursor) {
                resultHolder.add(resourceName);
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName propertyName) {
                return false;
            }
        };
        this.recordsDeepMatching(resourceName, visitor);
        return Collections.enumeration(resultHolder);
    }

    public StoredProperty get(ResourceName resourceName, QualifiedName propertyName) throws CoreException {
        final Object[] resultHolder = new Object[1];
        IVisitor simpleVisitor = new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty property, IndexCursor cursor) {
                resultHolder[0] = property;
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName propertyName) {
                return true;
            }
        };
        this.recordsMatching(resourceName, propertyName, simpleVisitor);
        return (StoredProperty)resultHolder[0];
    }

    public QueryResults getAll(ResourceName resourceName, int depth) throws CoreException {
        final QueryResults result = new QueryResults();
        IVisitor visitor = new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty property, IndexCursor cursor) {
                result.add(resourceName, property);
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName propertyName) {
                return true;
            }
        };
        if (depth == 0) {
            this.recordsMatching(resourceName, visitor);
        } else {
            this.recordsDeepMatching(resourceName, visitor);
        }
        return result;
    }

    public QueryResults getNames(ResourceName resourceName, int depth) throws CoreException {
        QueryResults results = new QueryResults();
        if (depth == 0) {
            this.recordsMatching(resourceName, this.propertyNameVisitor(results));
        } else {
            this.recordsDeepMatching(resourceName, this.propertyNameVisitor(results));
        }
        return results;
    }

    public boolean isRunning() {
        return this.store != null;
    }

    protected IVisitor propertyNameVisitor(final QueryResults results) {
        return new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty property, IndexCursor cursor) {
                results.add(resourceName, property.getName());
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName propertyName) {
                return false;
            }
        };
    }

    protected void recordsDeepMatching(ResourceName resourceName, IVisitor visitor) throws CoreException {
        StoreKey searchKey = new StoreKey(resourceName, true);
        byte[] searchBytes = searchKey.toBytes();
        int probe = searchBytes.length;
        IndexCursor cursor = this.store.getCursor();
        try {
            cursor.find(searchBytes);
            while (cursor.keyMatches(searchBytes)) {
                byte[] matchingBytes = cursor.getKey();
                if (probe == 1 || matchingBytes[probe] == 0 || matchingBytes[probe] == 47) {
                    this.visitPropertyAt(cursor, visitor);
                }
                cursor.next();
            }
            cursor.close();
        }
        catch (Exception e) {
            throw new ResourceException(271, resourceName.getPath(), Policy.bind("properties.storeProblem"), e);
        }
    }

    protected void recordsMatching(ResourceName resourceName, IVisitor visitor) throws CoreException {
        StoreKey searchKey = new StoreKey(resourceName, false);
        byte[] searchBytes = searchKey.toBytes();
        IndexCursor cursor = this.store.getCursor();
        try {
            cursor.find(searchBytes);
            while (cursor.keyMatches(searchBytes)) {
                this.visitPropertyAt(cursor, visitor);
                cursor.next();
            }
            cursor.close();
        }
        catch (Exception e) {
            this.store.reset();
            throw new ResourceException(271, resourceName.getPath(), Policy.bind("properties.storeProblem"), e);
        }
    }

    protected void recordsMatching(ResourceName resourceName, QualifiedName propertyName, IVisitor visitor) throws CoreException {
        StoreKey searchKey = new StoreKey(resourceName, propertyName);
        byte[] searchBytes = searchKey.toBytes();
        IndexCursor cursor = this.store.getCursor();
        try {
            cursor.find(searchBytes);
            if (cursor.keyEquals(searchBytes)) {
                this.visitPropertyAt(cursor, visitor);
            }
            cursor.close();
        }
        catch (Exception e) {
            this.store.reset();
            throw new ResourceException(271, resourceName.getPath(), Policy.bind("properties.storeProblem"), e);
        }
    }

    public QueryResults remove(ResourceName resourceName, QualifiedName[] propertyNames, int depth, int removeRule) throws CoreException {
        QueryResults failures = new QueryResults();
        if (depth == 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                boolean found = this.basicRemove(resourceName, propertyNames[i]);
                if (found || removeRule != 1) continue;
                failures.add(resourceName, propertyNames[i]);
            }
        } else {
            Enumeration resourceNamesEnum = this.deepResourceNames(resourceName);
            while (resourceNamesEnum.hasMoreElements()) {
                ResourceName resName = (ResourceName)resourceNamesEnum.nextElement();
                for (int i = 0; i < propertyNames.length; ++i) {
                    boolean found = this.basicRemove(resName, propertyNames[i]);
                    if (found || removeRule != 1) continue;
                    failures.add(resName, propertyNames[i]);
                }
            }
        }
        return failures;
    }

    public void remove(ResourceName resourceName, QualifiedName propertyName) throws CoreException {
        this.remove(resourceName, new QualifiedName[]{propertyName}, 0, 0);
    }

    public void removeAll(ResourceName resourceName, int depth) throws CoreException {
        QueryResults namesSearch = this.getNames(resourceName, depth);
        Enumeration resourceNamesEnum = namesSearch.getResourceNames();
        while (resourceNamesEnum.hasMoreElements()) {
            ResourceName resName = (ResourceName)resourceNamesEnum.nextElement();
            Enumeration propertyNamesEnum = Collections.enumeration(namesSearch.getResults(resName));
            while (propertyNamesEnum.hasMoreElements()) {
                QualifiedName propertyName = (QualifiedName)propertyNamesEnum.nextElement();
                this.basicRemove(resName, propertyName);
            }
        }
    }

    public QueryResults set(ResourceName resourceName, StoredProperty[] properties, int depth, int mode) throws CoreException {
        QueryResults failures = new QueryResults();
        this.commonSet(resourceName, properties, depth, mode, failures);
        return failures;
    }

    public void set(ResourceName resourceName, StoredProperty property) throws CoreException {
        this.commonSet(resourceName, new StoredProperty[]{property}, 0, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(IProgressMonitor monitor) {
        if (this.store == null) {
            return;
        }
        try {
            this.store.close();
        }
        finally {
            this.store = null;
        }
    }

    public void startup(IProgressMonitor monitor) {
    }

    protected void visitPropertyAt(IndexCursor cursor, IVisitor visitor) throws CoreException {
        try {
            StoreKey key = new StoreKey(cursor.getKey());
            ResourceName resourceName = key.getResourceName();
            QualifiedName propertyName = key.getPropertyName();
            String propertyValue = null;
            if (visitor.requiresValue(resourceName, propertyName)) {
                propertyValue = this.store.getObjectAsString(cursor.getValueAsObjectID());
            }
            visitor.visit(resourceName, new StoredProperty(propertyName, propertyValue), cursor);
        }
        catch (Exception e) {
            throw new ResourceException(271, null, Policy.bind("properties.storeProblem"), e);
        }
    }

    public void commit() throws CoreException {
        this.store.commit();
    }
}

