/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.content.Context;
import android.net.Uri;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.fl;
import com.google.android.gms.internal.fo;
import com.google.android.gms.plus.model.moments.Moment;
import com.google.android.gms.plus.model.moments.MomentBuffer;
import com.google.android.gms.plus.model.people.Person;
import com.google.android.gms.plus.model.people.PersonBuffer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlusClient
implements GooglePlayServicesClient {
    final fl rb;

    PlusClient(fl plusClientImpl) {
        this.rb = plusClientImpl;
    }

    public String getAccountName() {
        return this.rb.getAccountName();
    }

    public void writeMoment(Moment moment) {
        this.rb.writeMoment(moment);
    }

    public void loadMoments(OnMomentsLoadedListener listener) {
        this.rb.loadMoments(listener);
    }

    public void loadMoments(OnMomentsLoadedListener listener, int maxResults, String pageToken, Uri targetUrl, String type, String userId) {
        this.rb.loadMoments(listener, maxResults, pageToken, targetUrl, type, userId);
    }

    public void removeMoment(String momentId) {
        this.rb.removeMoment(momentId);
    }

    public void loadVisiblePeople(OnPeopleLoadedListener listener, int orderBy, String pageToken) {
        this.rb.loadVisiblePeople(listener, orderBy, pageToken);
    }

    public void loadVisiblePeople(OnPeopleLoadedListener listener, String pageToken) {
        this.rb.loadVisiblePeople(listener, pageToken);
    }

    public void loadPeople(OnPeopleLoadedListener listener, Collection<String> personIds) {
        this.rb.a(listener, personIds);
    }

    public void loadPeople(OnPeopleLoadedListener listener, String ... personIds) {
        this.rb.a(listener, personIds);
    }

    public Person getCurrentPerson() {
        return this.rb.getCurrentPerson();
    }

    public void clearDefaultAccount() {
        this.rb.clearDefaultAccount();
    }

    public void revokeAccessAndDisconnect(OnAccessRevokedListener listener) {
        this.rb.revokeAccessAndDisconnect(listener);
    }

    @Override
    public void connect() {
        this.rb.connect();
    }

    @Override
    public boolean isConnected() {
        return this.rb.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.rb.isConnecting();
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.rb.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.rb.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.rb.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.rb.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.rb.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.rb.unregisterConnectionFailedListener(listener);
    }

    @Override
    public void disconnect() {
        this.rb.disconnect();
    }

    fl cR() {
        return this.rb;
    }

    public static class Builder {
        private final Context mContext;
        private final GooglePlayServicesClient.ConnectionCallbacks rc;
        private final GooglePlayServicesClient.OnConnectionFailedListener ir;
        private final fo rd;

        public Builder(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
            this.mContext = context;
            this.rc = connectionCallbacks;
            this.ir = connectionFailedListener;
            this.rd = new fo(this.mContext);
        }

        public Builder setAccountName(String accountName) {
            this.rd.Z(accountName);
            return this;
        }

        public Builder setScopes(String ... scopes) {
            this.rd.d(scopes);
            return this;
        }

        public Builder clearScopes() {
            this.rd.dg();
            return this;
        }

        public Builder setActions(String ... actions) {
            this.rd.e(actions);
            return this;
        }

        public PlusClient build() {
            return new PlusClient(new fl(this.mContext, this.rd.dh(), this.rc, this.ir));
        }
    }

    public static interface OnAccessRevokedListener {
        public void onAccessRevoked(ConnectionResult var1);
    }

    public static interface OnPeopleLoadedListener {
        public void onPeopleLoaded(ConnectionResult var1, PersonBuffer var2, String var3);
    }

    public static interface OrderBy {
        public static final int ALPHABETICAL = 0;
        public static final int BEST = 1;
    }

    public static interface OnMomentsLoadedListener {
        public void onMomentsLoaded(ConnectionResult var1, MomentBuffer var2, String var3, String var4);
    }
}

